// **************************************************************************
// * File:   LoadableObjectSupport.cpp										*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Misc declarations required by the load code.					*
// **************************************************************************

#include "Ertsys.hpp"

//--------------------------------------------------------------------------------------------------------------------
// Functions for kicking off the storing / loading process; note that these deal with catching any exception thrown
// during de-serialization ...
//--------------------------------------------------------------------------------------------------------------------

_eMap < _aExceptionId :: _eEnum _mComma SerialErrorType :: _eEnum > exIdToSysErrMap ()
{
    _mBeginConstant (_vConstValue_3_7, _eMap < _aExceptionId :: _eEnum _mComma SerialErrorType :: _eEnum >)
    _vConstValue_3_7 = _eMap < _aExceptionId :: _eEnum _mComma SerialErrorType :: _eEnum >
		( _eSeq < _aExceptionId :: _eEnum > ()._lAppend
		  ( _aExceptionId :: eSsWriteError, _aExceptionId :: eSsInternalError, _aExceptionId :: eSsReadError, _aExceptionId :: eSsMissingInstantiation)._lAppend (
			_aExceptionId :: eSsMissingHeap, _aExceptionId :: eSsUnexpectedType, _aExceptionId :: eSsMissingType, _aExceptionId :: eSsCorruptStream
		  ),
		  _eSeq < SerialErrorType :: _eEnum > ()._lAppend
		  ( SerialErrorType :: writeError, SerialErrorType :: internalError, SerialErrorType :: readError, SerialErrorType :: missingInstantiation)._lAppend (
        	SerialErrorType :: missingHeap, SerialErrorType :: unexpectedType, SerialErrorType :: missingType, SerialErrorType :: corruptStream
		  )
		);
    _mEndConstant (_vConstValue_3_7)
}

void _lStoreObject (const _eStorable *obj, Environment *env, const _eOutputStream *strm, const _eInt version, _eHndlUnionVoid<SerialError> &err)
{
    _mSchema (storeObject);
	try
	{
		obj->store(env, strm, version);
	}
	catch (const _aEselExceptionWrapper& exception)
	{
		_aExceptionId :: _eEnum exId(exception.id());
    	err = new SerialError(exIdToSysErrMap().dom()._ovIn(exId)
				? exIdToSysErrMap()[exId] : SerialErrorType :: unspecifiedError, exception.msg());
		return;
	}
	catch( ... )
	{
		throw;							// not a 'Perfect' exception so let someone else deal with it ...
	}
	err = _mNullPtr (SerialError);		// Success (no exception thrown)!
}

void _lAttemptLoad(_eHndl < _eFillStream > & strgStrm, _eUnion & object)
{
    _mSchema (attemptLoad);
    _eFrom < _eStorable > obj;
	try
	{
    	strgStrm.Change ().initializeStream ();
    	strgStrm.Change ()._afill (obj);
	}
	catch (const _aEselExceptionWrapper& exception)
	{
		_aExceptionId :: _eEnum exId(exception.id());
		_rstring exMsg(exception.msg());
		object = _eUnion(static_cast<const _eAny *>(new SerialError(exIdToSysErrMap().dom()._ovIn(exId)
				? exIdToSysErrMap()[exId] : SerialErrorType :: unspecifiedError, exMsg)));
		return;
	}
	catch( ... )
	{
		throw;			// not a 'Perfect' exception so let someone else deal with it ...
	}
    object = static_cast < const _eAny * > (obj.Ptr ());
}

// Some constants ...

// ESEL notion of the runtime defined sequence of type-info's for basic int, bool, char etc. Required when we need
// to instantiate an instance of one these wrapped types for a value of a universal union ...
_eSeq < _eHndl < _eInstblTypeInfo > > _lBasicTypeInfos ()
{
    _mBeginConstant (_vConstValue_8_7, _eSeq < _eHndl < _eInstblTypeInfo > >)
    _vConstValue_8_7 = _eSeq < _eHndl < _eInstblTypeInfo > > ()
	._lAppend (_atypeInform<_eInt>::get())._lAppend (_atypeInform<_eBool>::get())._lAppend (_atypeInform<_eChar>::get())
	._lAppend (_atypeInform<_eReal>::get())._lAppend (_atypeInform<_eByte>::get())._lAppend (_atypeInform<_eRank::_eEnum>::get());
    _mEndConstant (_vConstValue_8_7)
}

// End.
