// **************************************************************************
// * File:   NtSystemCalls.hpp											   	*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Code to implement an interface between runtime and Win32		*
// * Note:   This interface was compiled and tested under Microsoft Visual  *
// *         C++ V6, with must be compiled with Microsoft language			*
// *         directives enabled (i.e. without the /Za switch)				*
// **************************************************************************

#if !defined(_h_NTsystemcalls)
#define _h_NTsystemcalls

//-----------------------------------------------
// Functions grouped into namespace '_eosInterface'
//-----------------------------------------------

namespace _eosInterface
{
	//---------------------------------------------------------------------------------
	// Function: Initialize()
	// Purpose: Set up any static data that is needed.
	//---------------------------------------------------------------------------------
	void initialize();

	//---------------------------------------------------------------------------------
	// Function: normalizefilename(const _eNativeChar *path, const _eNativeChar *fname)
	// Purpose:  Given a filename and a default path ("path"), split it into a full
	//           path and a filename ("fname") without path. The default path must
	//           either be empty (in which case the current directory is assumed)
	//           or end in "\". The split parts are held in the FilePath object
	//           returned on success, else null is returned.
	//---------------------------------------------------------------------------------
	_eHndlUnionVoid<FilePath> normalizefilename(const _eNativeChar *path, const _eNativeChar *fname);

	//---------------------------------------------------------------------------------
	// Make chmod call to set file attributes
	//---------------------------------------------------------------------------------
	FileError :: _eEnum chmod(const _eNativeChar *fname, _eSet<FileAttribute :: _eEnum> atts);

	//-------------------------------------------------------------------
	// Function: caseSensitiveFileNames()
	// Purpose:  Obtain information from the OS as to whether or not the
	//           local filessystem is case sensitive.
	//-------------------------------------------------------------------
	bool caseSensitiveFileNames();

	//-------------------------------------------------------------------
	// Function: getPathSeparator()
	// Purpose:  Obtain information from the OS as to what the path
	//           separator character is on the local filessystem.
	//-------------------------------------------------------------------
	_eNativeChar getPathSeparator();

	//--------------------------------------------------------------------------------------------------------
	// Function: setCurrentThreadPriority(const _eNat priority)
	// Purpose:  Set the base priority of the current thread by setting the priority class of the current
	//           process, and the priority level of the current thread. 'Perfect' supports 20 priority levels.
	//           For more information, see MSDN entry "scheduling priorities".
	//--------------------------------------------------------------------------------------------------------
	bool setCurrentThreadPriority(const _eNat priority);

	//------------------------------------------------------------------------------
	// Function: getLocalTime()
	// Purpose:  Get the current local date and time, based on the current time-zone
	//			 settings.
	//------------------------------------------------------------------------------
	Time getLocalTime();

	//------------------------------------------------------------------------------
	// Function: getImageVersion(const _eNativeChar *moduleName = 0)
	// Purpose:  Get the version information for an executable image (this
	//           information will have been stored in the 'ProductVersion' field of
	//           the version resource of the module in question) as a sequence of
	//			 integers (4 integers for Win32). If no argument is passed, then the
	//			 module queried is the currently running executable, else a string
	//			 can be passed that is the name of another currently loaded module
	//			 (loaded into the currently running executable's address space that
	//			 is), for example the name of a DLL such as "msvcrt.dll" ...
	//------------------------------------------------------------------------------
	_eSeq < _eInt > getImageVersion(const _eNativeChar *moduleName = 0);

	//---------------------------------------------------------------------------------------------
	// Function: whichOs()
	// Purpose:  Determine which operating system is currently running. Return details of OS-type
	//           (windows95, 98, NT etc) and major and minor OS-version numbers ...
	//---------------------------------------------------------------------------------------------
	_eHndl<OsInfo> getOsInfo();
}

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
