// File CpuTimer.hpp
// D. Crocker, 18-11-2000

// This file defines a function to get a fine-grained timer for profiling purposes,
// and a type for storing that profile.

// For more information on the Pentium instruction used here see web page:
// "http://developer.intel.com/software/idap/resources/technical_collateral/pentiumii/rdtscpm1.htm#3.1. Out-of-Order-Execution"

#if !defined(_h_CpuTimer)

#define _h_CpuTimer

 #if defined(_MSC_VER)

   // Microsoft-specific assembly code
   typedef __int64 _eCpuTimer;
   inline _eCpuTimer _lGetCpuTimer()
   {
  #if defined(_WIN64)
	// VS 2005 beta 1 doesn't support inline assembly in 64-bit mode
	 return 0;
  #else
	 _eCpuTimer rslt;
	 __asm
	 {	cpuid							; CPUID to force previous instructions to complete (destroys AX BX CX DX)
		rdtsc							; RDTSC to read the Pentium timer register into DX:AX
		mov dword ptr rslt, eax			; store low dword of CPU clock count
		mov dword ptr rslt+4, edx		; store high dword of CPU clock count
	 }
	 return rslt;
  #endif
   }

 #elif defined(__BCPLUSPLUS__)

   // Borland-specific assembly code
   typedef __int64 _eCpuTimer;
   extern _eCpuTimer _lGetCpuTimer();	                        // Cpp Builder 6 doesn't allow assembly in inline functions

 #elif defined(__GNUC__)

   // GNU-specific assembly code ...
   typedef long long int _eCpuTimer;	// 64 bit integer under GNUC
   inline _eCpuTimer _lGetCpuTimer()
   {
	 _eCpuTimer rslt;
	 asm volatile (	"cpuid" : : : "eax", "ebx", "ecx", "edx" );
	 asm volatile ( "rdtsc" : "=A" (rslt) );
	 return rslt;
   }

 #endif

#endif

// End
