;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; File:          perfect-mode.el
;; Author:        Dominic Matthews for Escher Technologies Ltd, (C) 2001
;; Description:   Major mode definition for editing 'Perfect' source code under XEmacs v20.
;; Last modified: 03 March 2010
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Set-up syntax tables for the 'Perfect' mode
;; NOTE: no special syntax is defined here currently.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Ensure variable 'perfect-mode-syntax-table' is defined (this won't overwrite it's current value if it is) ...
(defvar perfect-mode-syntax-table nil
	"Syntax table used while in 'Perfect' mode." )

(defvar perfect-keywords
;
;       abstract absurd after any anything as assert associative axiom bag begin bool build catch
;       change char class commutative confined const decrease deferred define done early end enum
;       exists external false fi final float for forall from function ghost goto has
;       heap highest idempotent identity if import in inherits int interface internal invariant is it
;       keep let like limited loop lowest map name nonmember null of on opaque operator
;       out over pair par pass post pragma pre proof property public rank real redefine ref
;       repeated require result satisfy schema selector self seq set storable super
;       supports tag that then those throw total trace triple true try until value var via
;       void when within yield
;
        (list (concat
		"\\<\\("	;; START keyword match
		"abstract\\|absurd\\|after\\|anything\\|any\\|assert\\|as\\|associative\\|axiom\\|bag\\|begin\\|bool\\|build\\|catch\\|change\\|char\\|"
		"class\\|commutative\\|confined\\|const\\|decrease\\|deferred\\|define\\|done\\|early\\|end\\|enum\\|exempt\\|exists\\|"
		"external\\|false\\|final\\|fi\\|float\\|forall\\|for\\|from\\|function\\|ghost\\|goto\\|has\\|heap\\"
		"highest\\|idempotent\\|identity\\|if\\|inherits\\|interface\\|internal\\|int\\|invariant\\|in\\|import\\|is\\|it\\|keep\\|"
        	"let\\|like\\|limited\\|loop\\|lowest\\|map\\|name\\|nonmember\\|null\\|of\\|opaque\\|operator\\|"
		"on\\|out\\|over\\|pair\\|par\\|pass\\|post\\|pragma\\|pre\\|proof\\|property\\|public\\|rank\\|real\\|redefine\\|ref\\|result\\|"
		"repeated\\|require\\|satisfy\\|schema\\|selector\\|self\\|set\\|seq\\|storable\\|super\\|supports\\|tag\\|that\\|then\\|"
		"those\\|throw\\|total\\|trace\\|triple\\|true\\|try\\|until\\|value\\|var\\|via\\|void\\|when\\|within\\|yield\\|"
		"\^\="					;; this doesn't work
		"\\)\\>" )	;; END keyword match
	      "[\(\)\[\]\{\}\;\:\^\=\.\&\!\~]?" )	;; neither does this
;
	"Regular-expression used for keyword highlighting in 'Perfect' mode." )

;; set up perfect font-lock for the following configuration :-
;; perfect-keywords (see 23.5.2)
(defvar perfect-font-lock-defaults
	'( perfect-keywords ;;perfect-font-lock-keywords
	   nil			;; dont inhibit string & comment highlighting
	   nil			;; dont ignore case during keyword matching
	   (
	    (?/ . ". 12")	;; the '/' character is the 1st & 2nd char of a 2-char comment start sequence
	    (?\n . ">  ")	;; the 'newline' character is the comment end marker

	    (?\ . " ")		;; put whitespace character (space) in the whitespace syntax class

	    (?\( . "()  ")
	    (?\) . ")(  ")
	    (?\[ . "(]  ")
	    (?\] . ")[  ")
	    (?\{ . "(}  ")
	    (?\} . "){  ")
	   )
	   nil )		;; irrelevent fn
	"The font-lock-defaults for the 'Perfect' mode." )

;; If the table was not defined (ie. the defvar set it up as 'nil'), define it ...
(if (not perfect-mode-syntax-table)
	(setq perfect-mode-syntax-table (make-syntax-table))
	(modify-syntax-entry ?/ ". 12" perfect-mode-syntax-table)	;; the '/' character is the 1st & 2nd char of a 2-char comment start sequence
	(modify-syntax-entry ?\n ">  " perfect-mode-syntax-table)	;; the 'newline' character is the comment end marker

	(modify-syntax-entry ?\  " "   perfect-mode-syntax-table)	;; put whitespace character (space) in the whitespace syntax class

	(modify-syntax-entry ?\( "()  " perfect-mode-syntax-table)
	(modify-syntax-entry ?\) ")(  " perfect-mode-syntax-table)
	(modify-syntax-entry ?\[ "(]  " perfect-mode-syntax-table)
	(modify-syntax-entry ?\] ")[  " perfect-mode-syntax-table)
	(modify-syntax-entry ?\{ "(}  " perfect-mode-syntax-table)
	(modify-syntax-entry ?\} "){  " perfect-mode-syntax-table)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Set-up abbreviations for the 'Perfect' mode
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Ensure variable 'perfect-mode-abbrev-table' is defined (this won't overwrite it's current value if it is) ...
(defvar perfect-mode-abbrev-table nil
	"Abbrev table used while in 'Perfect' mode." )

;; Call the function 'define-abbrev-table' to set-up the abbreviation table (see 36.2 of the EMACS manual) ...
(define-abbrev-table 'perfect-mode-abbrev-table ())

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Set-up key-mappings for the 'Perfect' mode
;; NOTE: no special key-mappings are defined here presently.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Ensure variable 'perfect-mode-map' is defined (this won't overwrite it's current value if it is) ...
(defvar perfect-mode-map nil
	"Key-mappings used while in 'Perfect' mode." )

;; If the map was not defined (ie. the defvar set it up as 'nil'), define it (see 22.3 of the EMACS manual) ...
(if (not perfect-mode-map)
	(setq text-mode-map (make-sparse-keymap)) )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define the major mode function for 'Perfect'
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun perfect-mode ()
	"Major EMACS mode for editing 'Perfect' code."
	(interactive)
	(kill-all-local-variables)
	(use-local-map perfect-mode-map)
	(setq local-abbrev-table perfect-mode-abbrev-table)
	(make-local-variable 'paragraph-start)
	(setq paragraph-start (concat "[ \t]*$\\|" page-delimiter))
	(make-local-variable 'paragraph-separate)
	(setq paragraph-separate paragraph-start)
	(setq mode-name "Perfect")
	(setq major-mode 'perfect-mode)
	(make-local-variable 'compile-command)
	(setq compile-command (concat "pdtool $PERFECTOPTIONS " (buffer-file-name) ) )	; so we compile 'current' buffer
	(font-lock-mode)				; so that syntax highlighting is turned on
	(setq tab-width 4)
	(run-hooks 'perfect-mode-hook) )			; this permits the user to customize the mode with a hook.

;; add 'font-lock-defaults' as a property of the major mode - this sets up for syntax highlighting. Note that if we just
;; set the symbol 'font-lock-defaults' directly, we end up making the 'Perfect' syntax global to all buffers, regardless of their
;; major mode; the properties method used here avoids this problem ...
(put 'perfect-mode 'font-lock-defaults perfect-font-lock-defaults)

;; End.
