/* File wctype.h supplied with Escher C Verifier.
 * Use this file only if you are using the eCv preprocessor.
 * If you wish to use a compiler to preprocess C/C++ source instead, then
 *  you should use the standard include files supplied with that compiler.
 */

#if !defined(__ecv_wctype_h_included__)
#define __ecv_wctype_h_included__

#if defined(__ECV__)

# if !defined(__ecv_wint_t_defined__)
#   define __ecv_wint_t_defined__
	  typedef int wint_t;
	  typedef int wctype_t;
# endif

typedef struct { int dummy; } wctrans_t;

int iswalnum(wint_t);
int iswalpha(wint_t);

# if defined(__STDC_VERSION__) && (__STDC_VERSION__ >= 199901L)
int iswblank(wint_t);
# endif

int iswcntrl(wint_t);
int iswdigit(wint_t);
int iswgraph(wint_t);
int iswlower(wint_t);
int iswprint(wint_t);
int iswpunct(wint_t);
int iswspace(wint_t);
int iswupper(wint_t);
int iswxdigit(wint_t);

wint_t towctrans(wint_t, wctrans_t);
wint_t towlower(wint_t);
wint_t towupper(wint_t);
wctrans_t wctrans(const char* _ecv_array);
wctype_t wctype(const char* _ecv_array);

# if !defined(WEOF)
#   if __ECV_WCHAR_UNSIGNED__
#     define WEOF		((wint_t) ((1u << __ECV_WCHAR_BITS__) - 1u))
#   else
#     define WEOF		((wint_t) (-1))
#   endif
# endif

#else
# error Missing macro definitions!. Use this include file only when running Escher C verifier.
#endif

#endif

/* End */
