/* File stdlib.h supplied with Escher C Verifier.
 * Use this file only if you are using the eCv preprocessor.
 * If you wish to use a compiler to preprocess C/C++ source instead, then
 *  you should use the standard include files supplied with that compiler.
 */

#if !defined(__ecv_stdlib_h_included__)
#define __ecv_stdlib_h_included__

#if defined(__ECV__) && defined(__ECV_CHAR_UNSIGNED__) && defined(__ECV_WCHAR_UNSIGNED__) \
 && defined(__ECV_CHAR_BITS__) && defined(__ECV_WCHAR_BITS__) \
 && defined(__ECV_SHORT_BITS__) && defined(__ECV_INT_BITS__) && defined(__ECV_LONG_BITS__) \
 && defined(__ECV_LONG_LONG_BITS__) && defined(__ECV_POINTER_BITS__) \
 && defined(__ECV_FLOAT_BITS__) && defined(__ECV_DOUBLE_BITS__) && defined(__ECV_LONG_DOUBLE_BITS__)

/* Define size_t. We assume that size_t should be defined as an unsigned integral type just long enough to contain a pointer.
 * size_t is also defined in some other header files, hence the guard. */

# if !defined(__ecv_size_t_defined__)
#   if __ECV_INT_BITS__ >= __ECV_POINTER_BITS__
	  typedef unsigned int size_t;
#     define __ecv_size_t_defined__
#   elif __ECV_LONG_BITS__ >= __ECV_POINTER_BITS__
	  typedef unsigned long int size_t;
#     define __ecv_size_t_defined__
#   else
	  typedef unsigned long long int size_t;
#     define __ecv_size_t_defined__
#   endif
# endif

# if !defined(NULL)
#   if defined(__cplusplus)
#    define NULL (0)
#   else
#    define NULL ((void*)0)
#   endif
# endif

/* We don't need to define wchar_t because eCv treats it as a separate built-in type */

double atof(const char* _ecv_array nptr);
int atoi(const char* _ecv_array nptr);
long int atol(const char* _ecv_array nptr);

# if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
long long int atoll(const char* _ecv_array nptr);
# endif

double strtod					(const char* _ecv_array _ecv_restrict nptr, char* _ecv_array * _ecv_null _ecv_restrict endptr) _ecv_writes(*_ecv_not_null(endptr));
long int strtol					(const char* _ecv_array _ecv_restrict nptr, char* _ecv_array * _ecv_null _ecv_restrict endptr, int base) _ecv_writes(*_ecv_not_null(endptr));
unsigned long int strtoul		(const char* _ecv_array _ecv_restrict nptr, char* _ecv_array * _ecv_null _ecv_restrict endptr, int base) _ecv_writes(*_ecv_not_null(endptr));

# if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
float strtof					(const char* _ecv_array _ecv_restrict nptr, char* _ecv_array * _ecv_null _ecv_restrict endptr) _ecv_writes(*_ecv_not_null(endptr));
long double strtold				(const char* _ecv_array _ecv_restrict nptr, char* _ecv_array * _ecv_null _ecv_restrict endptr) _ecv_writes(*_ecv_not_null(endptr));
long long int strtoll			(const char* _ecv_array _ecv_restrict nptr, char* _ecv_array * _ecv_null _ecv_restrict endptr, int base) _ecv_writes(*_ecv_not_null(endptr));
unsigned long long int strtoull	(const char* _ecv_array _ecv_restrict nptr, char* _ecv_array * _ecv_null _ecv_restrict endptr, int base) _ecv_writes(*_ecv_not_null(endptr));
# endif

# define RAND_MAX	((1 << ((__ECV_INT_BITS__) - 1u)) - 1)	/* same as INT_MAX */
int rand(void);
void srand(unsigned int seed);

void *calloc(size_t nmemb, size_t size);
void free(void *ptr) _ecv_writes();
void *malloc(size_t size);
void *realloc(void *ptr, size_t size) _ecv_writes();

# define EXIT_FAILURE	(255)
# define EXIT_SUCCESS	(0)

void abort(void);
int atexit(void (*func)(void));
void exit(int status);
void _Exit(int status);

char *getenv(const char *name);
int system(const char *string);

/* Although we declare bsearch and qsort, eCv currently can't reason about them because of the casts to/from void*.
 * We suggest writing type-specific versions instead. */
void* bsearch(const void* key, const void* base, size_t nmemb, size_t size, int (*compar)(const void*, const void*));
void qsort(void* base, size_t nmemb, size_t size, int (*compar)(const void*, const void*)) _ecv_writes(base.all);

int abs(int j);
typedef struct { int quot; int rem; } div_t;
div_t div(int numer, int denom);

long int labs(long int j);
typedef struct { long int quot; long int rem; } ldiv_t;
ldiv_t ldiv(long int numer, long int denom);

# if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
long long int llabs(long long int j);
typedef struct { long long int quot; long long int rem; } lldiv_t;
lldiv_t lldiv(long long int numer, long long int denom);
# endif

# define MB_CUR_MAX		(4)		/* assume UTF-8 */

int mblen(const char* _ecv_array _ecv_null s, size_t n);
int mbtowc(wchar_t* _ecv_null _ecv_restrict pwc, const char* _ecv_array _ecv_null _ecv_restrict s, size_t n) _ecv_writes(*_ecv_not_null(pwc));
int wctomb(char* _ecv_array _ecv_null s, wchar_t wchar) _ecv_writes(_ecv_not_null(s).all);
size_t mbstowcs(wchar_t* _ecv_array _ecv_restrict pwcs, const char* _ecv_array _ecv_restrict s, size_t n) _ecv_writes(pwcs.all);
size_t wcstombs(char* _ecv_array _ecv_restrict s, const wchar_t* _ecv_array _ecv_restrict pwcs, size_t n) _ecv_writes(s.all);

#else
# error Missing macro definitions! Use this include file only when running Escher C verifier.
#endif

#endif

/* End */
