# Script to build the runtime system, and construct the internal library
# for use by the PdTool makefile ...

BUILDLOG=`eval pwd`/build-runtime-log
LIBNAMER=perfectruntime.a
LIBNAMED=perfectruntime-debug.a
LIBLNKNAMER=libperfectruntime.a
LIBLNKNAMED=libperfectruntime-debug.a

ALL=

while [ $# -gt 0 ]
do
  if [ "$1" = "-all" ]; then
    ALL=yes
  elif [ "$1" = "-?" ]; then
    echo Internal script for \[re\]building the Perfect Developer runtime system
    echo Usage: $0 \[-all\]
    exit 0
  else
    echo Unknown option \'$1\'
	exit 1
  fi
  shift
done

echo >> $BUILDLOG
echo '*****' Runtime build started `eval date` '*****' >> $BUILDLOG
echo >> $BUILDLOG

if [ "$ALL" = "yes" ]; then
  echo Re-making entire runtime system ...
  echo Re-making entire runtime system ... >> $BUILDLOG
  make clean 2>&1 | tee -a $BUILDLOG
else
  echo Making runtime system ...
  echo Making runtime system ... >> $BUILDLOG
fi

make release 2>&1 | tee -a $BUILDLOG
if [ $? -ne 0 ]; then
  echo Failed to make the runtime system \(see \'$BUILDLOG\' for details\), aborting!
  echo Failed to make the runtime system, aborting! >> $BUILDLOG
  exit 1
fi

echo Constructing runtime library archive \'$LIBNAMER\' ...
echo Constructing runtime library archive \'$LIBNAMER\' ... >> $BUILDLOG
find release/*.o -print | xargs ar rcosv $LIBNAMER 2>&1 >> $BUILDLOG
if [ $? -ne 0 ]; then
  echo Failed to construct runtime library archive \(see \'$BUILDLOG\' for details\)!
  echo Failed to construct runtime library archive! >> $BUILDLOG
  exit 2
fi

# If the symbolic link to the library (required by the -L/l gcc option) doesn't exist, create it ...
if [ ! -f $LIBLNKNAMER ]; then
  ln -s $LIBNAMER $LIBLNKNAMER
fi

# Now the debug version...
make debug 2>&1 | tee -a $BUILDLOG
echo Constructing runtime debug library archive \'$LIBNAMED\' ...
echo Constructing runtime debug library archive \'$LIBNAMED\' ... >> $BUILDLOG
find debug/*.o -print | xargs ar rcosv $LIBNAMED 2>&1 >> $BUILDLOG
if [ $? -ne 0 ]; then
  echo Failed to construct runtime debug library archive \(see \'$BUILDLOG\' for details\)!
  echo Failed to construct runtime debug library archive! >> $BUILDLOG
  exit 2
fi

if [ ! -f $LIBLNKNAMED ]; then
  ln -s $LIBNAMED $LIBLNKNAMED
fi

echo Success!!
echo Success!! >> $BUILDLOG
echo >> $BUILDLOG
exit 0

# End.
