// **************************************************************************
// * File:   Variants.cpp													*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Code to implement variant checking logic						*
// **************************************************************************

//---------
// Includes
//---------

#include "Ertsys.hpp"
#include <cstdlib>

//---------------------------------------------------------------------------
// Specification/implementation variant checking code: Note that we only
// compile this code if the appropriate runtime check flag (_dVariant) is set
//---------------------------------------------------------------------------

#if !defined(NDEBUG)

  bool _eVariant::Check(_eVar i)
  {
	if (i < 0)
   		return false;

	if (IsChecking)
	{
		if (i < Last(Index))
			IsChecking = false;
		else if (i > Last(Index) || Index == Number() - 1)
			return false;
	}
	This(Index++) = i;
	CheckEnd();
	return true;
  }

  // This is called if we could not evaluate this component of the variant, so we will not have called Check()...
  void _eVariant::CannotEvaluate()
  {
	IsChecking = false;
	Index++;
	CheckEnd();
  }

  void _xVariant::appendMessage(_eWorkspace ws, _eSize& size) const
  {
	_xDebug::appendMessage(ws, size);
	append(ws, _mCstr("\nThe failed variant was: {"), size);
	_eSize i;
	for(i = 0; i < Index; i++)
	{
		append(ws, List[i], size);
		append(ws, _mCstr(", "), size);
	}
	append(ws, List[i++], size);
	append(ws, _mCstr(" -> "), size);
	append(ws, Tried, size);
	for(; i < static_cast<_eSize>(List._oHash()); i++)
	{
		append(ws, _mCstr(", "), size);
		append(ws, List[i], size);
	}
	append(ws, _mCstr("}."), size);
  }

  _xVariant::_xVariant( _eVar tried, const _eVariant& v,
  						const _eCallStackInfo& info, _eCstr file_name,
						_eNat line )
	: _xDebug(info, file_name, line), Tried(tried), Index(v.Index)
  {
		List = *new _eVector<_eVar>(static_cast<_eNat>(v.Number()));
		_eSize i;
		for(i = 0; i < Index; i++)
			List.add(v.This(i));
		for(; i < v.Number(); i++)
      		List.add(v.Last(i));
  }

#endif

// End.
