// **************************************************************************
// * File:   IncludeOrderWorkarounds_1.hpp									*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Global forwarding functions to resolve include order problems	*
// *         in the runtime system.	 										*
// **************************************************************************


#include "Ertsys.hpp"

// File inclusions for forward declarations

#include "IncludeOrderWorkarounds_0.hpp"

// File inclusions for full declarations

#include "IncludeOrderWorkarounds_1.hpp"
#include "StorageStream_1.hpp"


void _lIncludeOrderWorkarounds :: writeCollectionHdr (_eStoreStream * stream, const _eInt collLength)
{
    _mSchema (writeCollectionHdr);
    _mDontShare (stream);
    stream -> writeCollectionHdr (collLength);
}

void _lIncludeOrderWorkarounds :: setupRepeatedData (_eStoreStream * stream, const _eComplexValue :: _eEnum repCode, const _eInt collLength)
{
    _mSchema (setupRepeatedData);
    _mDontShare (stream);
    stream -> setupRepeatedData (repCode, collLength);
}

void _lIncludeOrderWorkarounds :: readCollectionHdr (_eFillStream * stream, _eInt & collLength)
{
    _mSchema (readCollectionHdr);
    _mDontShare (stream);
    stream -> readCollectionHdr (collLength);
}


// End of file.
