// **************************************************************************
// * File:   EarlyMisc.cpp													*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Miscellaneous runtime functions that are required before the	*
// *         definition of built in collections.							*
// **************************************************************************

//---------
// Includes
//---------

#include "Ertsys.hpp"
#include "EarlyMisc.hpp"

// Representation of the constant we use as the dummy parameter passed to the special
// constructors of storable classes during the 'fill' process
_aEmptyClass _adummyParam ()
{
    _mBeginConstant (_vConstValue_adummyParam, _aEmptyClass)
    _vConstValue_adummyParam = _aEmptyClass ();
    _mEndConstant (_vConstValue_adummyParam)
}

// Function to allow us to throw storage-exceotions from the low-level classes (_eHandle and _eFrom)
void _athrowStorageException(const _eNativeChar *msg, const _aExceptionId :: _eEnum id)
{
	_aThrow((_eFrom<_eEselException>(_mAsFrom(new _aStreamException(_lString(msg), id), _eEselException))).Ptr());
}

// Names of _eComplexValue enumeration constants
const _eNativeChar* _eComplexValue :: _lnaming[30] =
{
    _mCstr("CV_RSVD"), _mCstr("CV_SYSSTR"), _mCstr("CV_REP"), _mCstr("CV_NULL"), _mCstr("CV_END"), _mCstr("CV_HNDL"), _mCstr("CV_ANOTHERHNDL"), _mCstr("CV_SMALL"),
        _mCstr("CV_REF"), _mCstr("CV_ANOTHERREF"), _mCstr("CV_UNION"), _mCstr("CV_COLLECTION"), _mCstr("CV_ENUM_1"), _mCstr("CV_ENUM_2"),
        _mCstr("CV_ENUM_4"), _mCstr("CV_INT_0"), _mCstr("CV_INT_1"), _mCstr("CV_INT_2"), _mCstr("CV_INT_4"), _mCstr("CV_INT_8"), _mCstr("CV_INT_L"),
        _mCstr("CV_CHAR"), _mCstr("CV_BOOL"), _mCstr("CV_REAL"), _mCstr("CV_DOUBLE"), _mCstr("CV_DCL_HEAP"), _mCstr("CV_DCL_STYPE"), _mCstr("CV_DCL_TTYPE"),
        _mCstr("CV_DCL_INSTN"), _mCstr("CV_BYTE")
};

// End.
