// **************************************************************************
// * File:   Any.cpp														*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Definition of non-inline member methods of classes in Any		*
// **************************************************************************

#include "Ertsys.hpp"

#include "Any.hpp"

//------------------------------------------------------------------------------------------------------------------
// Class '_eFullTypeInfo' - class to hold type-info about a class and a reference to the parent's full-type-info
// to allow us to recurse up the type tree in the rank logic. The 'AnyBase' class declares a deferred function that
// returns an instance this of this class ...
//------------------------------------------------------------------------------------------------------------------

_rstring _eFullTypeInfo::name() const
{
	return myTypeInfo->getTypeTableEntry().typeName;
}
_eBool _eFullTypeInfo::operator==(const _eFullTypeInfo *other) const
{
	return myTypeInfo == other->myTypeInfo && gen == other->gen;
}

//-----------------------------------------------------
// Class '_eAny' - base class for all handle classes...
//-----------------------------------------------------

_eHndl<_eInstblTypeInfo> _eAny::_aGetMyTypeInfo() const
{
	return _aGetFullTypeInfo()->typeInfo();
}

// End
