// **************************************************************************
// * File:   Sockets.hpp													*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Declarations for socket class.									*
// **************************************************************************

#if !defined(_h_Sockets)
#define _h_Sockets

#if defined(_MSC_VER)
  // SOCKET is defined in Winsock2.h, but that file isn't always included
  #if defined(_WIN64)
    typedef unsigned __int64 SOCKET;
  #else
    typedef unsigned int SOCKET;
  #endif
#else
  typedef int SOCKET;
#endif

class _eSocket : public _eAny
{
	bool bSocketReady;
	SOCKET conn_socket;		// the actual socket itself
	SocketError::_eEnum seError;
	SocketMode::_eEnum smMode;
	// The following is only relevant for server sockets (and only valid after a sucessful 'awaitConnection(..)' call) ...
	SOCKET msgsock;	// after accepting a connection, this is the socket opened for talking on (the original socket only manages connections)
	_eSeq<_eInt> remoteAddress;		// after accepting a connection, this is the IP address of the remote client
	_eInt remotePort;				// after accepting a connection, this is the port of the remote client

	// Private method to initialize socket services on the host machine ...
	bool initializeWinsock();

	// Private method to actually open and connect to a TCP socket - called by the CTORs
	// of this class only ...
	bool OpenTcpSocket(struct sockaddr_in &socketData, _eInt portNumber, bool serverMode);

  public:
    _mDefineType(_eSocket)
    _mDefineCopy(_eSocket)
    _mEqualsOperator(_eSocket)
    _mPerfectTypeInfoHdrNA(_eSocket)
    _mNew(_eSocket)

	// Equality operator required by the '_mEqualsOperator(..)' macro ...
   	_eBool operator==(const _eSocket * a) const
	{
		return bSocketReady == a->bSocketReady &&
			   conn_socket == a->conn_socket &&
			   seError == a->seError &&
			   smMode == a->smMode;
	}

	// Constructor to generate a socket connected to the specified port number at the specified IP address (as
	// a sequence of 4 nats) ...
	_eSocket(_eSeq< _eByte > ipAddress, _eInt portNumber, const SocketMode::_eEnum sktMode);

	// Constructor to generate a socket connected to the specified port number at the specified host (the
	// 'MY COMPUTER' name) ...
	_eSocket(const _rstring &hostName, _eInt portNumber, const SocketMode::_eEnum sktMode);

	~_eSocket();

	// Wait for a connection to this server socket (ie. block), and accept the first one that comes along. If all is well,
	// set the result value to true, to indictate that a user may now call 'read(..)' on the socket to obtain the data
	// waiting. If there is some problem, return false and store an appropriate error (if we are not a server socket, we
	// just return straight away after setting the appropriate error) ...
	void awaitConnection(bool &res);

	// Schema to allow user to close the connection socket established by the last call to 'awaitConnection(..)'. If we
	// are not a server socket, return failed) ...
	void closeConnection(bool &res);

	_eSeq<_eInt> getRemoteAddress() const
	{
		return remoteAddress;
	}

	_eInt getRemotePort() const
	{
		return remotePort;
	}

	//**************************************************
	// Routines to read byte sequences from the socket *
	//**************************************************

	// Read data from the socket ...
	void read(_eSeq <_eByte > &rdata, bool &res);
	// Read data if any is available but don't block if not, just return an empty string instead ...
	void read_noblock(_eSeq <_eByte > &rdata, bool &res);

	//*************************************************
	// Routine to write Perfect strings to the socket *
	//*************************************************

	void write(const _rstring &wdata, bool &res);

	//******************************************************
	// Routines to read/write Perfect bytes from/to socket *
	//******************************************************

	// Read the specified sequence number of 8-bit bytes from the socket specified (return a seq of nat or a SocketError) ...

	// Read the specified number of 8-bit bytes from the socket specified (return a seq of byte or a SocketError) ...
    virtual void read (const _eInt, _eUnion &);
    virtual void write (const _eSeq < _eByte >, SocketError :: _eEnum &);
	// Read an 8-bit byte from the socket specified (return a byte or a SocketError) ...
    virtual void read (_eUnion &);
    virtual void write (const _eByte, SocketError :: _eEnum &);

	bool ready() const
	{
		return bSocketReady;
	}

	// Function to obtain the last network error recorded (or 'None' if last operation suceeded) ...
	SocketError::_eEnum getLastError() const;

	// Schema to allow user to close the socket when he has finished with it ...
	void closeSocket(bool &res);
};

#endif

// End.
