// Runtime variables for the Perfect Developer runtime system

#if !defined(_h_RuntimeVars)
#define _h_RuntimeVars

namespace _eEscherRuntime
{
	//---------------------------------------------------------------------------
	// Runtime check flags.
	// Note that each of these will only be effective when running a debug
	// build that had the relevant check generated by the Perfect Developer Tool.
	//---------------------------------------------------------------------------

	extern _eBool EnablePre;
	extern _eBool EnablePost;
	extern _eBool EnableLoopInvariant;
	extern _eBool EnableLoopDecrease;
	extern _eBool EnableSpecDecrease;
	extern _eBool EnableImpDecrease;
	extern _eBool EnablePostAssert;
	extern _eBool EnableEmbeddedAssert;
	extern _eBool EnableLastChoice;
	extern _eBool EnableClassInvariant;
	extern _eBool EnableConstraints;

	// This flag is normally true but we set it to false just before making a 'super' call
	extern _eBool notSuper;

	// This count is used to allow us to abort nested checks for everything except loop-invariant
	// checks (these are NEVER allowed to do nested checks, else we would blow the stack!). An
	// example is where we have an expression that we test in an assertion; this may call a function
	// that itself has an assertion - this is the kind of nesting we are talking about.
	extern unsigned int MaxCheckNesting;
	extern unsigned int CurrentCheckNesting;

	// This flag allows us to not destroy the objects on any global heaps on program termination -
	// the operating system can take care of this for us.
	extern _eBool Terminated;

	//--------------------------------------
	// Definitions for the runtime callstack
	//--------------------------------------

	const unsigned int maxStackOutput = 50;
	extern const _eNativeChar *stringArray[maxStackOutput];

	extern const int EselExceptionFailureCode;
	extern const int UxpdExceptionFailureCode;
	extern const int AllocFailureCode;

	#if defined(_MSC_VER)
 		extern int __cdecl failedAllocHandler(size_t size);
	#endif
}	                                                            // end namespace

#endif

// End
