// **************************************************************************
// * File:   Pragmas.hpp													*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Target C++ compiler pragmas.	 								*
// **************************************************************************

#if !defined(_h_pragmas)
#define _h_pragmas

//----------------------
// Borland 5.5.1 pragmas
//----------------------

#if defined(__BCPLUSPLUS__)
  // don't warn about failure to expand inline
  #pragma warn -inl
  // don't warn about parameter that is never used
  #pragma warn -par
  // don't warn about non-virtual functions hiding virtual ones
  #pragma warn -hid
  //
#endif

//-----------------------
// Visual C++ 6.0 pragmas
//-----------------------

#if defined(_MSC_VER)
  // This can arise for example in: (this is X).m' = x
  // A current implementation cannot cope with this.
  // DC 22-3-2004: I suspect that we no longer need this (I have never seen this error message)
  #pragma warning(error : 4270)

  #if _MSC_VER >= 1200 && _MSC_VER < 1300
	// Pragmas for Visual C++ 6.0

	// Disable unreferenced formal parameter warning
	#pragma warning(disable : 4100)
	// Disable "local variable is initialized but not referenced" warning
	#pragma warning(disable : 4189)
	// Disable "assignment operator could not be generated" message
	#pragma warning(disable : 4512)
	// Disable "local variable xxx may be used without having been initialized"
	#pragma warning(disable : 4701)
	// Disable "unreachable code" warning (it is usually wrong)
	#pragma warning(disable : 4702)
	// Disable "function not inlined" warning
	#pragma warning(disable : 4710)
	// Disable "function selected for automatic inline expansion" warning
	#pragma warning(disable : 4711)
    // Disable "identifier truncated in debug info" warning
    #pragma warning(disable : 4786)
  #endif

  #if _MSC_VER >= 1300
	// Pragmas for Visual C++ .NET 7.x

	// Disable unreferenced formal parameter warning
	#pragma warning(disable : 4100)
	// Disable "local variable is initialized but not referenced" warning
	#pragma warning(disable : 4189)
	// Disable "assignment operator could not be generated" message
	#pragma warning(disable : 4512)
	// Disable "local variable xxx may be used without having been initialized"
	#pragma warning(disable : 4701)
  #endif

  #if _MSC_VER >= 1400
	// Pragmas for Visual C++ .NET Whidbey

	// Disable 'structured exceptions are no longer caught' warning
	#pragma warning(disable : 4571)
	// Disable deprecated function warning
	#pragma warning(disable : 4996)
  #endif
#endif

//-----------------------
// Intel compiler pragmas
//-----------------------

#if defined(__INTEL_COMPILER)
  // Disable the warnings for method hiding (1125) and '$' in identifier name (468)
  #pragma warning(disable : 1125 468)
#endif

//-----------------------------
// Green Hills compiler pragmas
//-----------------------------

#if defined(__ghs__)
  // Disable warning messages about overriding (610 and 611)
  #pragma ghs nowarning 610
  #pragma ghs nowarning 611
#endif

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
