// **************************************************************************
// * File:   Dmacro.hpp														*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Macros controlling generation of run-time debug checks.		*
// **************************************************************************

#if !defined(_h_dmacro)
#define _h_dmacro

//----------------------------------------------------------------------
// Macro to define the strictness of the runtime checking.
// Change the definition to nonzero to enable stricter runtime checking
//----------------------------------------------------------------------

#define _dExtraRuntimeChecks (0)

//-------------------------------------------------------
// Macros to define activeness of specific runtime checks
//-------------------------------------------------------

#if defined(NDEBUG)
  // All set to zero since compiler is in RELEASE mode
  #define _dMemory			(0)
  #define _dCannotHappen	(0)
  #define _dCheckCast		(0)
  #define _dCppInfo			(0)
  #define _dNoChoice		(0)
  #define _dLastChoice		(0)

  #if defined(_dProfile)
  	// If _dProfile has been defined in the C++ compiler options, turn _dCallStack on as well so as enable profiling
    #define _dCallStack		(1)
  #else
    #define _dProfile		(1)
  	// Otherwise, turning _dProfile on and _dCallStack off allows building a release version of the library that
  	// supports profiling of applications but doesn't include profiling of non-template library routines
    #define _dCallStack		(0)
  #endif

#else
  // Make these macros non-zero to turn on the relevant DEBUG feature
  #define _dCallStack		(1)
  #define _dMemory			(1)
  #define _dCannotHappen	(1)
  #define _dCheckCast		(1)
  #define _dCppInfo			(1)
  #define _dNoChoice		(1)
  #define _dLastChoice	   	(1)
  // There is no point in profiling debug checks so we turn profiling off here ...
  #define _dProfile			(0)

#endif

//DQM#if !defined(_dThreadSafe)
//DQM	// If _dThreadSafe has not been defined in the C++ compiler options, turn it off by default ...
//DQM	#define _dThreadSafe	(0)
//DQM#endif

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
