#!/bin/bash
# Shell script post-build step command file for building a C++ application from Perfect Developer

# Set the program name
PROGRAM="hello"

# Definitions for the Release version
PERFECTLIB="/opt/escher/lib/libperfectruntime.a"
CFLAGS="-I/opt/escher/include -DNDEBUG -Wall -Wno-unused -Wno-uninitialized -O3"

# Use these alternative definitions to build a debug version
#PERFECTLIB="/opt/escher/lib/libperfectruntime-debug.a"
#CFLAGS="-I/opt/escher/include -Wall -Wno-unused -Wno-uninitialized -ggdb"

################# Start of script ###################

cd ./cplusplus

# Check that the Perfect run-time library exists
if [ ! -f "$PERFECTLIB" ]; then
	echo "Post-build file: PERFECTLIB setting is incorrect (can't find $PERFECTLIB)"
	exit 1
fi

echo "Compiling C++ files..."
g++ -c $CFLAGS *.cpp

if [ $? -ne 0 ]; then
	exit 1
fi

echo "Linking..."
g++ -o $PROGRAM *.o -L/opt/escher/lib -lperfectruntime

# End
