/* File stdarg.h supplied with Escher C Verifier.
 * Use this file only if you are using the eCv preprocessor.
 * If you wish to use a compiler to preprocess C/C++ source instead, then
 *  you should use the standard include files supplied with that compiler.
 */

#if !defined(__ecv_stdarg_h_included__)
#define __ecv_stdarg_h_included__

# if !defined(_ecv_va_list_defined)
#  define _ecv_va_list_defined
typedef struct { const char* _ecv_array _ecv_null p; unsigned int s; } va_list;
# endif

# define va_start(_x, _parmN)	{ (_x).p = reinterpret_cast<const char* _ecv_array>(&_parmN); (_x).s = static_cast<unsigned int>(sizeof(_parmN)); }
# define va_arg(_x, _t)        	( (_x).p += (_x).s, (_x).s = static_cast<unsigned int>(sizeof(_t)), *reinterpret_cast<_t*>(_x) )
# define va_end(_x)				{ (_x).p = 0; }

# if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#  define va_copy(_dst, _src)	{ _dst = _src }
# endif

#endif

/* End */
