// **************************************************************************
// * File:   ModuleDescriptorSupport.cpp									*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Definitions used to define and obtain the module descriptor 	*
// *         (MDx) nodes.													*
// **************************************************************************

#include "Ertsys.hpp"

//-------------------------------------------------------------------------------------
// Initialisation of the static list root pointer (the declaration in the .hpp is only
// a declaration; we provide the definition here. See ANSI 9.4.2.2 for an explanation.
//-------------------------------------------------------------------------------------

_eMDH* _eMDH::root = NULL;

//-----------------------------------------------------
// Class to represent a Module Descriptor Header (node)
//-----------------------------------------------------

_eBool _eModuleDescriptorAddress :: valid() const
{
    _mFunction (valid);
	return nodePtr != NULL;
}

_eNat _eModuleDescriptorAddress :: getMDHnodeIndex() const
{
    _mFunction (getMDHnodeIndex);
	return nodePtr -> getMDHnodeIndex();
}

_eHndl<_eModuleDescriptorData> _eModuleDescriptorAddress :: getMDdata () const
{
    _mFunction (getMDdata);
    return nodePtr -> getModuleData();
}

_eFrom <_eStorable> _eModuleDescriptorAddress :: templateInstantiate(const _eNat instnTableIndex) const
{
    _mFunction (templateInstantiate);
	_mBeginPre _mCheckPre (valid(), "0,0");
    return nodePtr -> createTmplLoadableObjFn(instnTableIndex);
}

_eFrom <_eStorable> _eModuleDescriptorAddress :: regtypeInstantiate(const _eNat typeTableIndex) const
{
    _mFunction (regtypeInstantiate);
	_mBeginPre _mCheckPre (valid(), "0,0");
    return nodePtr -> createRegrLoadableObjFn(typeTableIndex);
}

_eAddress _eModuleDescriptorAddress :: obtainHeapAddress (const _eNat heapTableIndex) const
{
    _mFunction (obtainHeapAddress);
	_mBeginPre _mCheckPre (valid(), "0,0");
    return nodePtr -> getHeapAddressFn(heapTableIndex);
}

_eBool _eModuleDescriptorAddress :: existMDlistNext() const
{
    _mFunction (existMDlistNext);
	_mBeginPre _mCheckPre (valid(), "0,0");
    return nodePtr -> getNextNode() != NULL;
}

_eModuleDescriptorAddress _eModuleDescriptorAddress :: getMDlistNext() const
{
    _mFunction (getMDlistNext);
	_mBeginPre _mCheckPre (valid(), "0,0");
    return _eModuleDescriptorAddress(nodePtr -> getNextNode());
}

_eModuleDescriptorAddress :: _eModuleDescriptorAddress(const _eMDH* ptr)
{
	_mBuild;
	nodePtr = const_cast<_eMDH*>(ptr);
}

_eModuleDescriptorAddress :: _eModuleDescriptorAddress()
{
	_mBuild;
	nodePtr = NULL;
}

_eBool _eModuleDescriptorAddress :: operator == (const _eModuleDescriptorAddress & _vEqualityArg) const
{
    _mOperator (=);
    return nodePtr == _vEqualityArg.nodePtr;
}

//------------------------------------------------------------------------------------
// Function to obtain the head node of the system-wide Module Descriptor Header (MDH)
// list. We use this to traverse the MDH list during searches ...
//------------------------------------------------------------------------------------

_eModuleDescriptorAddress _agetMDlistHead()
{
    _mFunction (getMDlistHead);
    return _eModuleDescriptorAddress(_eMDH::root);
}

//--------------------------------------------------------------------------------
// Definitions required for the MDA constant that describes the builtin types ...
//--------------------------------------------------------------------------------

// The MDD data that is held in a node (an MDH node) ...
// Notes:
// (1) The entries (including the order) of the entries in this table _MUST_ be consistant with the enumerations in
//     'ModuleDescriptorSupport_1.hpp';
// (2) The type names appearing here MUST be the final names of the types;
//
static const _eHndl<_eModuleDescriptorData> _amoduleData = _eHndl<_eModuleDescriptorData>
	( new _eModuleDescriptorData( _eSeq<_eHeapTableEntry>(),
								  _eSeq<_eTypeTableEntry>()._lAppend(
									_eTypeTableEntry(_mString("int"), 0, _eSeq<_eSeparatorId :: _eEnum>()),
									_eTypeTableEntry(_mString("bool"), 0, _eSeq<_eSeparatorId :: _eEnum>()),
									_eTypeTableEntry(_mString("char"), 0, _eSeq<_eSeparatorId :: _eEnum>()),
									_eTypeTableEntry(_mString("real"), 0, _eSeq<_eSeparatorId :: _eEnum>()),
									_eTypeTableEntry(_mString("byte"), 0, _eSeq<_eSeparatorId :: _eEnum>()),
									_eTypeTableEntry(_mString("rank"), 0, _eSeq<_eSeparatorId :: _eEnum>()),
									_eTypeTableEntry(_mString("seq"), 1, _eSeq<_eSeparatorId :: _eEnum>()),
									_eTypeTableEntry(_mString("set"), 1, _eSeq<_eSeparatorId :: _eEnum>()),
									_eTypeTableEntry(_mString("bag"), 1, _eSeq<_eSeparatorId :: _eEnum>()),
									_eTypeTableEntry(_mString("map"), 2, _eSeq<_eSeparatorId :: _eEnum>(_eSeparatorId::RightArrow)),
									_eTypeTableEntry(_mString("pair"), 2, _eSeq<_eSeparatorId :: _eEnum>(_eSeparatorId::Comma)),
									_eTypeTableEntry(_mString("triple"), 3, _eSeq<_eSeparatorId :: _eEnum>()._lAppend(_eSeparatorId::Comma, _eSeparatorId::Comma)),
									_eTypeTableEntry(_mString("_eMultiple2"), 2, _eSeq<_eSeparatorId :: _eEnum>()._lAppend(_eSeparatorId::Comma)),
									_eTypeTableEntry(_mString("_eMultiple3"), 3, _eSeq<_eSeparatorId :: _eEnum>()._lAppend(_eSeparatorId::Comma, _eSeparatorId::Comma)),
									_eTypeTableEntry(_mString("_eMultiple4"), 4, _eSeq<_eSeparatorId :: _eEnum>()._lAppend(_eSeparatorId::Comma, _eSeparatorId::Comma, _eSeparatorId::Comma)),
									_eTypeTableEntry(_mString("$Ref"), 1, _eSeq<_eSeparatorId :: _eEnum>()) )._lAppend(
									_eTypeTableEntry(_mString(""), 0, _eSeq<_eSeparatorId :: _eEnum>()),				// For universal union
									_eTypeTableEntry(_mString("_aExceptionId"), 0, _eSeq<_eSeparatorId :: _eEnum>()),	// For hand-coded enum
									_eTypeTableEntry(_mString("_eComplexValue"), 0, _eSeq<_eSeparatorId :: _eEnum>()),	// For hand-coded enum
									_eTypeTableEntry(_mString("Environment"), 0, _eSeq<_eSeparatorId :: _eEnum>()),		// For hand-coded class
									_eTypeTableEntry(_mString("_eSocket"), 0, _eSeq<_eSeparatorId :: _eEnum>()),		// For hand-coded class
									_eTypeTableEntry(_mString("FileRef"), 0, _eSeq<_eSeparatorId :: _eEnum>()),		// For hand-coded class
									_eTypeTableEntry(_mString("_lLowLevelSupport"), 0, _eSeq<_eSeparatorId :: _eEnum>()),		// For hand-coded class
									_eTypeTableEntry(_mString("_eAnyBase"), 0, _eSeq<_eSeparatorId :: _eEnum>()) )._lAppend(		// To avoid special cases (where we inherit from Any or AnyBase) in generated code
									_eTypeTableEntry(_mString("_eAddress"), 0, _eSeq<_eSeparatorId :: _eEnum>()) ),		// This is just here to satisfy the compiler (we store maps of _eAddess -> ...) and the map type-info needs a type-info for both the types in the map
								  _eSeq<_eInstantiationTableEntry>() ) );

// The regular-type creation function ...
static _eFrom <_eStorable> _acreateRegularObject(const _eNat _atypeIndex)
{
    _mFunction ($createLoadableObject);
    return ( (0 == _atypeIndex) ?
    			_eFrom<_eStorable>(_mAsFrom(new _eBasicTypeWrapper<_eInt>(0), _eStorable)) :
    		 (1 == _atypeIndex) ?
    			_eFrom<_eStorable>(_mAsFrom(new _eBasicTypeWrapper<_eBool>(false), _eStorable)) :
    		 (2 == _atypeIndex) ?
    			_eFrom<_eStorable>(_mAsFrom(new _eBasicTypeWrapper<_eChar>(false), _eStorable)) :
    		 (3 == _atypeIndex) ?
    			_eFrom<_eStorable>(_mAsFrom(new _eBasicTypeWrapper<_eReal>(0.0), _eStorable)) :
 			 _mCheckLastChoice
			 ( "0,0", (4 == _atypeIndex),
 			   _eFrom<_eStorable>(_mAsFrom(new _eBasicTypeWrapper<_eByte>(0), _eStorable))
			 )
		   );
}

// The node for this module (actually for the entire runtime system!) ...
static _eMDH _aobjLoaderNode (_amoduleData, &_acreateRegularObject, NULL, NULL);

// The constant MDA that describes the builtin types ...
_eModuleDescriptorAddress _ebuiltinTypeTable()
{
    _mBeginConstant (_vConstValue_61_7, _eModuleDescriptorAddress)
    _vConstValue_61_7 = _eModuleDescriptorAddress (&_aobjLoaderNode);
    _mEndConstant (_vConstValue_61_7)
}

// End.
