// File Entry.cs

using Ertsys;
using System.IO;
using System.Reflection;	// for Assembly

namespace hello
{
    public static class Entry
    {
        public static int Main(string[] jargs)
        {
            //----------------
            // Parse arguments
            //----------------
            string pathToClass = Path.GetDirectoryName(Assembly.GetExecutingAssembly().GetModules()[0].FullyQualifiedName);  // path to the executing assembly
            if (pathToClass.Length != 0 && pathToClass[pathToClass.Length - 1] != Path.DirectorySeparatorChar
                && pathToClass[pathToClass.Length - 1] != Path.AltDirectorySeparatorChar)
            {
                pathToClass = pathToClass + Path.DirectorySeparatorChar;
            }

            Environment context = new Environment(pathToClass);

            _eSeq<_eSeq<char>> pargs = new _eSeq<_eSeq<char>>(_eSystem._lString(pathToClass));
            foreach (string arg in jargs)
            {
                pargs = pargs.append(_eSystem._lString(arg));
            }

            // Execute the Perfect-generated user main
            int retval;
            _jMain.main(context, pargs, out retval);

            return retval;
        }
    }
}

// End
