/* File time.h supplied with Escher C Verifier.
 * Use this file only if you are using the eCv preprocessor.
 * If you wish to use a compiler to preprocess C/C++ source instead, then
 *  you should use the standard include files supplied with that compiler.
 */

#if !defined(__ecv_time_h_included__)
#define __ecv_time_h_included__

#pragma ECV noverify

# if !defined(NULL)
#   if defined(__cplusplus)
#    define NULL (0)
#   else
#    define NULL ((void* _ecv_null)0)
#   endif
# endif

#define CLOCKS_PER_SEC		(100)

# if !defined(__ecv_size_t_defined__)
#   if __ECV_INT_BITS__ >= __ECV_POINTER_BITS__
	  typedef unsigned int size_t;
#     define __ecv_size_t_defined__
#   elif __ECV_LONG_BITS__ >= __ECV_POINTER_BITS__
	  typedef unsigned long int size_t;
#     define __ecv_size_t_defined__
#   else
	  typedef unsigned long long int size_t;
#     define __ecv_size_t_defined__
#   endif
# endif

typedef unsigned long int clock_t;
typedef unsigned long int time_t;

struct tm {
	int tm_sec;
	int tm_min;
	int tm_hour;
	int tm_mday;
	int tm_mon;
	int tm_year;
	int tm_wday;
	int tm_yday;
	int tm_isdst;
};

clock_t clock(void);
double difftime(time_t time1, time_t time0);
time_t mktime(struct tm* timeptr) _ecv_writes(*timeptr);
time_t time(time_t* _ecv_null timer) _ecv_writes(*_ecv_not_null(timer));
char* _ecv_array asctime(const struct tm* timeptr);
char* _ecv_array ctime(const time_t* timer);
struct tm* gmtime(const time_t* timer);
struct tm* localtime(const time_t* timer);
size_t strftime(char* _ecv_array _ecv_restrict s, size_t maxsize, const char* _ecv_array _ecv_restrict format, const struct tm* _ecv_restrict timeptr) _ecv_writes(s.all);

#endif

/* End */
