/* File math.h supplied with Escher C Verifier.
 * Use this file only if you are using the eCv preprocessor.
 * If you wish to use a compiler to preprocess C/C++ source instead, then
 *  you should use the standard include files supplied with that compiler.
 */

#if !defined(__ecv_math_h_included__)
#define __ecv_math_h_included__

#pragma ECV noverify

#if defined(__ECV__)

# if (__ECV_DOUBLE_BITS__) == 64
#  define HUGE_VAL		(1.7976931348623157E+308)	/* same as DBL_MAX (could also be +ve infinity) */
# endif

# if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

#  if (__ECV_FLOAT_BITS__) == 32
#   define HUGE_VALF	(3.40282347E+38F)	/* same as FLT_MAX (could also be +ve infinity) */
#  endif

#  if (__ECV_LONG_DOUBLE_BITS__) == 64
#   define HUGE_VALL	(1.7976931348623157E+308)	/* same as LDBL_MAX (could also be +ve infinity) */
#  endif

#  if (__ECV_LONG_DOUBLE_BITS__) == 80
#   define HUGE_VALL	(1.1897314953572317650213E+4932L)	/* same as LDBL_MAX (could also be +ve infinity) */
#  endif

#  define INFINITY		(HUGE_VALF * 2.0F)

#  define NAN			(1)		/* assume NaNs are available */

int _ecv_fpclassifyf(float x);
int _ecv_fpclassifyd(double x);
int _ecv_fpclassifyl(long double x);

#  define fpclassify(_x) (sizeof(_x) == sizeof(float) \
							? _ecv_fpclassifyf(_x) \
							: sizeof(_x) == sizeof(double) \
								? _ecv_fpclassifyd(_x) \
								: _ecv_fpclassifyl(_x))

#  define FP_ZERO		(0)
#  define FP_SUBNORMAL	(1)
#  define FP_NORMAL		(2)
#  define FP_INFINITE	(3)
#  define FP_NAN		(4)

#  define isfinite(_x)	(fpclassify(_x) <= FP_NORMAL)
#  define isinf(_x)		(fpclassify(_x) == FP_INFINITE)
#  define isnan(_x)		(fpclassify(_x) == FP_NAN)

# endif

double acos(double);
double asin(double);
double atan(double);
double atan2(double, double);
double cos(double);
double sin(double);
double tan(double);
double cosh(double);
double sinh(double);
double tanh(double);

double exp(double);
double frexp(double, int *pexp) _ecv_writes(*pexp);
double ldexp(double, int);
double log(double);
double log10(double);
double modf(double, double *iptr) _ecv_writes(*iptr);

double pow(double, double);
double sqrt(double);

double ceil(double);
double fabs(double);
double floor(double);
double fmod(double, double);

#else
# error Missing macro definitions! Use this include file only when running Escher C verifier.
#endif

#endif

/* End */
