/* File float.h supplied with Escher C Verifier.
 * Use this file only if you are using the eCv preprocessor.
 * If you wish to use a compiler to preprocess C/C++ source instead, then
 *  you should use the standard include files supplied with that compiler.
 */

#if !defined(__ecv_float_h_included__)
#define __ecv_float_h_included__

#pragma ECV noverify

#if defined(__ECV__) && defined(__ECV_CHAR_UNSIGNED__) && defined(__ECV_WCHAR_UNSIGNED__) \
 && defined(__ECV_CHAR_BITS__) && defined(__ECV_WCHAR_BITS__) \
 && defined(__ECV_SHORT_BITS__) && defined(__ECV_INT_BITS__) && defined(__ECV_LONG_BITS__) \
 && defined(__ECV_LONG_LONG_BITS__) && defined(__ECV_POINTER_BITS__) \
 && defined(__ECV_FLOAT_BITS__) && defined(__ECV_DOUBLE_BITS__) && defined(__ECV_LONG_DOUBLE_BITS__)

/* Warning! These definitions assume IEEE 754 floating point representation! */

# define FLT_RADIX			(2)
# define FLT_ROUNDS			(-1)

# if (__ECV_FLOAT_BITS__) == 32
#  define FLT_MANT_DIG		(24)
#  define FLT_DIG			(6)
#  define FLT_EPSILON		(1.19209290E-07F)
#  define FLT_MIN_EXP		(-125)
#  define FLT_MIN			(1.17549435E-38F)
#  define FLT_MIN_10_EXP	(-37)
#  define FLT_MAX_EXP		(+128)
#  define FLT_MAX			(3.40282347E+38F)
#  define FLT_MAX_10_EXP	(+38)
# endif

# if (__ECV_DOUBLE_BITS__) == 64
#  define DBL_MANT_DIG		(53)
#  define DBL_DIG			(15)
#  define DBL_EPSILON		(2.2204460492503131E-16)
#  define DBL_MIN_EXP		(-1021)
#  define DBL_MIN			(2.2250738585072014E-308)
#  define DBL_MIN_10_EXP	(-307)
#  define DBL_MAX_EXP		(+1024)
#  define DBL_MAX			(1.7976931348623157E+308)
#  define DBL_MAX_10_EXP	(+308)
# endif

# if (__ECV_LONG_DOUBLE_BITS__) == 64
#  define LDBL_MANT_DIG		(53)
#  define LDBL_DIG			(15)
#  define LDBL_EPSILON		(2.2204460492503131E-16L)
#  define LDBL_MIN_EXP		(-1021)
#  define LDBL_MIN			(2.2250738585072014E-308L)
#  define LDBL_MIN_10_EXP	(-307)
#  define LDBL_MAX_EXP		(+1024)
#  define LDBL_MAX			(1.7976931348623157E+308L)
#  define LDBL_MAX_10_EXP	(+308)
# endif

# if (__ECV_LONG_DOUBLE_BITS__) == 80
#  define	LDBL_MANT_DIG	(64)
#  define	LDBL_DIG		(18)
#  define	LDBL_EPSILON	(1.0842021724855044340075E-19L)
#  define	LDBL_MIN_EXP	(-16381)
#  define	LDBL_MIN		(3.3621031431120935062627E-4932L)
#  define	LDBL_MIN_10_EXP	(-4931)
#  define	LDBL_MAX_EXP	(+16384)
#  define	LDBL_MAX		(1.1897314953572317650213E+4932L)
#  define	LDBL_MAX_10_EXP	(+4932)
# endif

# if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#  define DECIMAL_DIG		(10)	/* this is the minimum permited value, in practice it shouold be greater */
# endif

#else
# error Missing macro definitions! Use this include file only when running Escher C verifier.
#endif

#endif

/* End */
