#if !defined(__ECV_H_INCLUDED__)

#define __ECV_H_INCLUDED__

#pragma ECV noverify

/* Define the "normal" versions of the Arc keywords.
 * If any of these clash with identifiers in the user program, you can #undef them after including this file. */

#define any				_ecv_any
#define array			_ecv_array
#define assert(_x)		_ecv_assert(_x)
#define assume(_x)		_ecv_assume(_x)
#define decrease(_x)	_ecv_decrease(_x)
#define disjoint		_ecv_disjoint
#define exists			_ecv_exists
#define forall			_ecv_forall
#define ghost(_x)  		_ecv_ghost(_x)
#define holds			_ecv_holds
#define idiv			_ecv_idiv
#define imod			_ecv_imod
#define in				_ecv_in
#define integer			_ecv_integer
#define invariant(_x)	_ecv_invariant(_x)
#define keep(_x)		_ecv_keep(_x)
#define let				_ecv_let
#define maxof(_x)		_ecv_maxof(_x)
#define minof(_x)		_ecv_minof(_x)
#define min_sizeof(_x)	_ecv_min_sizeof(_x)
#define not_null(_x)	_ecv_not_null(_x)
#define null			_ecv_null
#define old				_ecv_old
#define out				_ecv_out
#define over			_ecv_over
#define post			_ecv_post
#define pre				_ecv_pre
#define result			_ecv_result
#define returns(_x)		_ecv_returns(_x)
#define some			_ecv_some
#define spec			_ecv_spec
#define that			_ecv_that
#define those			_ecv_those
#define value			_ecv_value
#define writes			_ecv_writes
#define yield			_ecv_yield
#define zero_init(_x)	_ecv_zero_init(_x)

#if defined(__ECV__)

/************************ The following definitions are only active when running eCv **********************/

#if defined(_MSC_VER)

/* Define Microsoft compiler-specific keywords as expanding to nothing */
#define __declspec(x)
#define __w64
#define __inline	inline

#if _MSC_VER >= 1400

/******************** Definitions for Microsoft compilers *********************
 * Microsoft file crtdefs.h (which is included by nearly everything else) contains some references to types not defined there.
 * To avoid problems, we include crtdefs.h here along with the files that define the missing types. */
#define __STDC_WANT_SECURE_LIB__	(0)	/* need this to undo some inline declarations that don't compile in eCv */
#define _CRT_SECURE_NO_WARNINGS		(1)
#include "crtdefs.h"
#include "locale.h"						/* defines "struct lconv" */
struct __lc_time_data { int x; };		/* this is defined only in the CRT source */
struct threadmbcinfostruct { int x; };	/* this is defined only in the CRT source */
#endif

#endif		/* end Microsoft compiler specific */

#if defined(__GNUC__)

/*********************** Definitions for Gnu Compiler Collection C and C++ compilers ********************/

#define __inline__	inline
#define __restrict__

/* Hide gcc __attribute__ keyword from eCv.
 * WARNING: some header files (e.g. _mingw.h) may "#undef __attribute__", which undoes this. */
#define __attribute__(_x)

/* The following are needed to handle gcc's implementation of variable argument lists */
typedef struct __builtin_va_list__ { int x; } __builtin_va_list;
extern void __builtin_va_start(__builtin_va_list, const char*);
extern void __builtin_va_end(__builtin_va_list);

#endif		/* end gcc specific */

#if defined HI_TECH_C

/****************************** Definitions for HiTech C compilers ********************************/

#define bit bool			/* define HiTech bit type as equivalent to bool */

/* Define the HiTech C extra type qualifiers as expanding to nothing */
#define interrupt			/* functions may be flagged as interrupt routines */
#define persistent
#define near
#define bank0
#define bank1
#define bank2
#define bank3
#define eeprom
#define __interrupt			/* functions may be flagged as interrupt routines */
#define __persistent
#define __near
#define __bank0
#define __bank1
#define __bank2
#define __bank3
#define __eeprom

#define asm(_x)				/* hide assembler from eCv */

#endif		/* end HiTech compiler specific */

/**************************** End of compiler-specific definitions ***************************/

#else		/* not running eCv */

/* Define eCv macros as expanding to nothing */
#define _ecv_array
#define _ecv_assert(_x)		((void)0)
#define _ecv_assume(_x)
#define _ecv_change(_x)
#define _ecv_decrease(_x)
#define _ecv_ghost(_x)
#define _ecv_invariant(_x)
#define _ecv_keep(_x)
#define _ecv_not_null(_x)	(_x)
#define _ecv_null
#define _ecv_out
#define _ecv_pass			((void)0)
#define _ecv_post(_x)
#define _ecv_pre(_x)
#define _ecv_returns(_x)
#define _ecv_spec
#define _ecv_writes(_x)

#endif		/* end "if defined(__ECV__) ... else ..." */

#endif		/* end header guard */

/* End of file */
