// **************************************************************************
// * File:   LoadableSupport_1.hpp											*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Misc declarations required by the load code.					*
// **************************************************************************

#if !defined(_h_Main_LoadableSupport)
#define _h_Main_LoadableSupport 1

#include "TypeInfo_0.hpp"
#include "TypeInfo_1.hpp"
#include "Union_0.hpp"
#include "Union_1.hpp"

//--------------------------------------------------------------------------------------------------------------------
// Functions for kicking off the storing / loading process; note that these deal with catching any exception thrown
// during de-serialization ...
//--------------------------------------------------------------------------------------------------------------------

extern void _lStoreObject (const _eStorable *obj, Environment *env, const _eOutputStream *strm, const _eInt version, _eHndlUnionVoid<SerialError> &err);
extern void _lAttemptLoad (_eHndl < _eFillStream > &,  _eUnion & object);

//--------------------------------------------------------------------
// Function used for building real storable handle instances and
// unions from raw addresses during de-serialization ...
//--------------------------------------------------------------------

inline _eFrom < _eStorable > _lBuildHandle(const _eAddress ptr)
{
	return (ptr != NULL) ? _eFrom < _eStorable >(static_cast<const _eStorable*>(ptr))
						 : _eFrom < _eStorable >();
}

inline _eUnion _lBuildUnion (const _eStorable* ptr)
{
    return (ptr != NULL ? _eUnion (ptr) : _eUnion(_mNull));
}

// Some constants ...

inline _eAddress _lNullAddress () { return NULL; }
extern _eSeq < _eHndl < _eInstblTypeInfo > > _lBasicTypeInfos ();

//----------------------------------------------------------------------------------
// The global template function used by the automatically generated 'myTypeInfo()'
// functions, to get template argument information (because 'myTypeInfo()' must
// return a complete-type ...
//----------------------------------------------------------------------------------

template<class X> struct _atypeInform
{
	static _eHndl<_eInstblTypeInfo> get()
	{
		return X :: _aMyTypeInfo();
	}
};

// Specializations of the above for builtin non-template types (we use a macro here for neatness - see MiscRts.hpp). For
// type-infos for builtin template types see file StorableSupport ...

// for basic types ...
_mBuiltinTypeInform(_eInt, _estcBasicTypeCode :: BUILTIN_TYPEIDX_INT)
_mBuiltinTypeInform(_eBool, _estcBasicTypeCode :: BUILTIN_TYPEIDX_BOOL)
_mBuiltinTypeInform(_eChar, _estcBasicTypeCode :: BUILTIN_TYPEIDX_CHAR)
_mBuiltinTypeInform(_eReal, _estcBasicTypeCode :: BUILTIN_TYPEIDX_REAL)
_mBuiltinTypeInform(_eByte, _estcBasicTypeCode :: BUILTIN_TYPEIDX_BYTE)
_mBuiltinTypeInform(_eRank::_eEnum, _estcBasicTypeCode :: BUILTIN_TYPEIDX_RANK)

// for hand-coded enums (that can't be compiled Perfect because of their position in the include order) ...
_mBuiltinTypeInform(_aExceptionId::_eEnum, _estcBasicTypeCode :: BUILTIN_TYPEIDX_ENUM_EXCEPTIONID)
_mBuiltinTypeInform(_eComplexValue::_eEnum, _estcBasicTypeCode :: BUILTIN_TYPEIDX_ENUM_COMPLEXVALUE)

// other, nasty, ones ...
_mBuiltinTypeInform(_eAnyBase, _estcBasicTypeCode :: BUILTIN_TYPEIDX_ANYBASE)
_mBuiltinTypeInform(_eAddress, _estcBasicTypeCode :: BUILTIN_TYPEIDX_EADDRESS)

// Note for the confused, regarding the 'myTypeInfo()' function for the collection classes:
// We cannot currently specify this function in Perfect because we can't call functions on
// template types (we need to do this in order to obtain the type-info of the type that the
// collection was instantiated with, just as we do for user template classes). To get around
// the problem we currently generate the function internally.

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
