// **************************************************************************
// * File:   Debug.hpp														*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Definitions of special 'debug' functionality defined in the	*
// *         runtime. Note that these functions should not be generally		*
// *         used since they buck the idea of a single program environment.	*
// **************************************************************************

#if !defined(_H_DEBUGFILE)
#define _H_DEBUGFILE 1

#if defined(_MSC_VER)
# include <intrin.h>
#endif

extern void _ltrace(const _rstring);		// defined in Debug.cpp

// Print a debug string to the console
#if defined(_dNoDebugPrint)
  // If we have disabled debug print, use a macro to avoid evaluating the arguments
  #define debugPrint(arg) (true)
#else
  // Use the function defined in file Debug.cpp
  inline _eBool debugPrint(const _rstring s)
  {
	_ltrace(s);
	return true;
  }
#endif

// Halt execution
inline _eBool debugHalt(const _rstring s)
{
	_ltrace(s);
	#if defined(_MSC_VER)
		__debugbreak();
	#elif defined(__GNUC__)
		__asm__
		( "int $3" );
	#endif
	return true;		// dummy return to prevent compiler waring about no return value.
}

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
