/*-------------------------------------------------------*/
/* File:    C:/Escher/Examples/ecv/bsearch.c             */
/* Author:  David Crocker                                */
/* Created: 10:04:53 on Monday December 13th 2010 UTC    */
/*-------------------------------------------------------*/

#include "ecv.h"
#include "bsearch.h"

/* Search a table of ordered elements of elem_t for the nearest match to 'key' */
size_t bsearch(const elem_t* array table, size_t numElems, elem_t key)
{
	size_t low = 0u, high = numElems;
	while (high > low)
	keep(low <= high; high <= numElems)
	keep(low == 0u || table[low - 1u] < key)
	keep(high == numElems || key <= table[high])
	decrease(high - low)
	{
		size_t mid = (high - low)/2u + low;			// get the mid point, avoiding arithmetic overflow
		if (key <= table[mid])
		{
			high = mid;
		}
		else
		{
			low = mid + 1u;
		}
	}
	return low;
}

/* End */
