;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; File:          .emacs
;; Author:        Dominic Matthews for Escher Technologies Ltd, (C) 2001
;; Description:   Emacs initialization file to add support for the 'Perfect' major mode.
;; Last modified: 7th March 2001
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Ensure emacs searches the Perfect customization directory ...
(setq load-path (cons "/usr/share/perfectdeveloper/emacs_cust/" load-path) )

;; Make emacs load the Perfect customization code when an 'Perfect' file is opened ...
(autoload 'perfect-mode "perfect-mode.el")

;; Prepend the mode info reqd for automatic syntax highlighting of 'Perfect' files. Note that
;; by prepending, we make 'Perfect' files take presedence over other files that have the same
;; file extension ...
(defvar auto-mode-alist nil
  "User specification of modes to use for standard file types." )
(setq auto-mode-alist
  (append '( ("\\.pd$" . perfect-mode) ) auto-mode-alist) )

;; Set-up the regular expression used for picking-up errors from the 'Perfect' compiler output ...
(require 'compile)
(setq compilation-error-regexp-alist (append '(("\\(..*\\.e\\) \(\\([0-9][0-9]*\\),\\([0-9][0-9]*\\)\):\\(..*\\([Ee]rror\\|[Ww]arning\\)..*\\)$" 1 2 3)) compilation-error-regexp-alist))

;; End.
