/* File stdio.h supplied with Escher C Verifier.
 * Use this file only if you are using the eCv preprocessor.
 * If you wish to use a compiler to preprocess C/C++ source instead, then
 *  you should use the standard include files supplied with that compiler.
 */

#if !defined(__ecv_stdio_h_included__)
#define __ecv_stdio_h_included__

#pragma ECV noverify

# if !defined(__ecv_size_t_defined__)
#   if __ECV_INT_BITS__ >= __ECV_POINTER_BITS__
	  typedef unsigned int size_t;
#     define __ecv_size_t_defined__
#   elif __ECV_LONG_BITS__ >= __ECV_POINTER_BITS__
	  typedef unsigned long int size_t;
#     define __ecv_size_t_defined__
#   else
	  typedef unsigned long long int size_t;
#     define __ecv_size_t_defined__
#   endif
# endif

# if !defined(_ecv_file_defined)
#  define _ecv_file_defined
typedef struct { int dummy; } FILE;
# endif

typedef struct { long long int pos; } fpos_t;

# if !defined(_ecv_va_list_defined)
#  define _ecv_va_list_defined
typedef struct { const void* _ecv_null p; unsigned int s; } va_list;
# endif

# if !defined(NULL)
#   if defined(__cplusplus)
#    define NULL (0)
#   else
#    define NULL ((void* _ecv_null)0)
#   endif
# endif

# define _IOFBF			(0)
# define _IOLBF			(1)
# define _IONBF			(2)

# define BUFSIZ			(1024)
# define EOF			(-1)
# define FOPEN_MAX		(20)
# define FILENAME_MAX	(1024)
# define L_tmpnam		(100)
# define SEEK_CUR		(0)
# define SEEK_END		(1)
# define SEEK_SET		(2)
# define TMP_MAX		(100)

extern FILE _ecv_files[];
# define stdin			(&_ecv_files[0])
# define stdout			(&_ecv_files[1])
# define stderr			(&_ecv_files[2])

int remove(const char* _ecv_array filename);
int rename(const char* _ecv_array oldname, const char* _ecv_array newname);
FILE *tmpfile(void);
char* _ecv_array tmpnam(char* _ecv_array _ecv_null s) _ecv_writes(_ecv_not_null(s).all);

int fclose(FILE* stream) _ecv_writes(*stream);
int fflush(FILE* _ecv_null stream) _ecv_writes(*_ecv_not_null(stream));
FILE* _ecv_null fopen(const char* _ecv_array _ecv_restrict filename, const char* _ecv_array _ecv_restrict mode) _ecv_writes(_ecv_files);
FILE* _ecv_null freopen(const char* _ecv_array _ecv_restrict filename, const char* _ecv_array _ecv_restrict mode, FILE* _ecv_restrict stream) _ecv_writes(*stream);
void setbuf(FILE* _ecv_restrict stream, char* _ecv_array _ecv_null _ecv_restrict buf) _ecv_writes(*stream; _ecv_not_null(buf).all);
int setvbuf(FILE* _ecv_restrict stream, char* _ecv_array _ecv_null _ecv_restrict buf, int mode, size_t size) _ecv_writes(*stream; _ecv_not_null(buf).all);
int fprintf(FILE* _ecv_restrict stream, const char* _ecv_array _ecv_restrict format, ...) _ecv_writes(*stream);
int fscanf(FILE* _ecv_restrict stream, const char* _ecv_array _ecv_restrict format, ...) _ecv_writes(*stream);
int printf(const char* _ecv_array _ecv_restrict format, ...) _ecv_writes(*stdout);
int scanf(const char* _ecv_array _ecv_restrict format, ...) _ecv_writes(*stdin);
int sprintf(char* _ecv_array _ecv_restrict s, const char* _ecv_array _ecv_restrict format, ...) _ecv_writes(s.all);
int sscanf(const char* _ecv_array _ecv_restrict s, const char* _ecv_array _ecv_restrict format, ...) _ecv_writes();
int vfprintf(FILE* _ecv_restrict stream, const char* _ecv_array _ecv_restrict format, va_list arg) _ecv_writes(*stream);
int vfscanf(FILE* _ecv_restrict stream, const char* _ecv_array _ecv_restrict format, va_list arg) _ecv_writes(*stream);
int vprintf(const char* _ecv_array _ecv_restrict format, va_list arg) _ecv_writes(*stdout);
int vscanf(const char* _ecv_array _ecv_restrict format, va_list arg) _ecv_writes();
int vsprintf(char* _ecv_array _ecv_restrict s, const char* _ecv_array _ecv_restrict format, va_list arg) _ecv_writes(s.all);
int vsscanf(const char* _ecv_array _ecv_restrict s, const char* _ecv_array _ecv_restrict format, va_list arg);

# if (defined(__STDC_VERSION__) && (__STDC_VERSION__ >= 199901L)) || (defined(__cplusplus) && (__cplusplus >= 201103L))
int snprintf(char* _ecv_array _ecv_restrict s, size_t n, const char* _ecv_array _ecv_restrict format, ...) _ecv_writes(s.all);
int vsnprintf(char* _ecv_array _ecv_restrict s, size_t n, const char* _ecv_array _ecv_restrict format, va_list arg) _ecv_writes(s.all);
# endif

int fgetc(FILE *stream) _ecv_writes(*stream);
char* _ecv_array _ecv_null fgets(char* _ecv_array _ecv_restrict s, int n, FILE* _ecv_restrict stream) _ecv_writes(s.all; *stream);
int fputc(int c, FILE* stream) _ecv_writes(*stream);
int fputs(const char* _ecv_array _ecv_restrict s, FILE* _ecv_restrict stream) _ecv_writes(*stream);
int getc(FILE *stream) _ecv_writes(*stream);
int getchar(void) _ecv_writes(*stdin);
char* _ecv_array gets(char* _ecv_array s) _ecv_writes(s.all; *stdin);
int putc(int c, FILE* stream) _ecv_writes(*stream);
int putchar(int c) _ecv_writes(*stdout);
int puts(const char* _ecv_array s) _ecv_writes(*stdout);
int ungetc(int c, FILE* stream) _ecv_writes(*stream);

size_t fread(void* _ecv_restrict ptr, size_t size, size_t nmemb, FILE* _ecv_restrict stream) _ecv_writes(ptr.all; *stream);
size_t fwrite(const void* _ecv_restrict ptr, size_t size, size_t nmemb, FILE* _ecv_restrict stream) _ecv_writes(*stream);
int fgetpos(FILE* _ecv_restrict stream, fpos_t* _ecv_restrict pos) _ecv_writes(*stream; *pos);
int fseek(FILE* stream, long int offset, int whence) _ecv_writes(*stream);
int fsetpos(FILE* stream, const fpos_t* pos) _ecv_writes(*stream);
long int ftell(FILE* stream) _ecv_writes(*stream);
void rewind(FILE* stream) _ecv_writes(*stream);
void clearerr(FILE* stream) _ecv_writes(*stream);
int feof(FILE* stream) _ecv_writes(*stream);
int ferror(FILE* stream) _ecv_writes(*stream);
void perror(const char* _ecv_array s);

#endif

/* End */
