/* File locale.h supplied with Escher C Verifier.
 * Use this file only if you are using the eCv preprocessor.
 * If you wish to use a compiler to preprocess C/C++ source instead, then
 *  you should use the standard include files supplied with that compiler.
 */

#if !defined(__ecv_locale_h_included__)
#define __ecv_locale_h_included__

#pragma ECV noverify

#if defined(__ECV__) && defined(__ECV_CHAR_UNSIGNED__) && defined(__ECV_WCHAR_UNSIGNED__) \
 && defined(__ECV_CHAR_BITS__) && defined(__ECV_WCHAR_BITS__) \
 && defined(__ECV_SHORT_BITS__) && defined(__ECV_INT_BITS__) && defined(__ECV_LONG_BITS__) \
 && defined(__ECV_LONG_LONG_BITS__) && defined(__ECV_POINTER_BITS__) \
 && defined(__ECV_FLOAT_BITS__) && defined(__ECV_DOUBLE_BITS__) && defined(__ECV_LONG_DOUBLE_BITS__)

/* Define the NULL macro */

# if !defined(NULL)
#   if defined(__cplusplus)
#    define NULL (0)
#   else
#    define NULL ((void* _ecv_null)0)
#   endif
# endif

# define LC_ALL			(401)
# define LC_COLLATE		(402)
# define LC_CTYPE		(403)
# define LC_MONETARY	(404)
# define LC_NUMERIC		(405)
# define LC_TIME		(406)

struct lconv {
char *decimal_point;
char *thousands_sep;
char *grouping;
char *mon_decimal_point;
char *mon_thousands_sep;
char *mon_grouping;
char *positive_sign;
char *negative_sign;
char *currency_symbol;
char frac_digits;
char p_cs_precedes;
char n_cs_precedes;
char p_sep_by_space;
char n_sep_by_space;
char p_sign_posn;
char n_sign_posn;
char *int_curr_symbol;
char int_frac_digits;
char int_p_cs_precedes;
char int_n_cs_precedes;
char int_p_sep_by_space;
char int_n_sep_by_space;
char int_p_sign_posn;
char int_n_sign_posn;

#ifdef __cplusplus
lconv();	// there must be a constructor for lconv, but we don't know the details
#endif
};

char* _ecv_array _ecv_null setlocale(int category, const char* _ecv_array _ecv_null locale);
struct lconv *localeconv(void);

#else
# error "Missing macro definitions!. Use this include file only when running Escher C verifier."
#endif

#endif

/* End */
