/*-----------------14/09/2010 12:45-----------------
 * Specifications for C functions in string.h
 * --------------------------------------------------*/

#if defined(__ECV__) && !defined(__ecv_string_h_spec_included__)
#define __ecv_string_h_spec_included__

#pragma ECV noverify

spec size_t strlen(const char* array src)
	pre(_ecv_isNullTerminated(src))
	post(result < src.lim)
	post(src[result] == '\0')
	post(forall i in 0..(result - 1) :- src[i] != '\0')
;

spec char* array strcpy(char* array dst, const char* array src)
	writes(dst.all)
	pre (_ecv_isNullTerminated(src))
	pre (disjoint(src.all, dst.all))
	pre (dst.upb > strlen(src))
	returns(dst)
	post (_ecv_isNullTerminated(dst))
	post (strlen(dst) == strlen(src))
	post (forall i in 0..strlen(src) :- dst[i] == src[i])
;

spec char* array strcat(char* array dst, const char* array src)
	writes(dst.all)
	pre (_ecv_isNullTerminated(src))
	pre (_ecv_isNullTerminated(dst))
	pre (disjoint(src.all, dst.all))
	pre (dst.lim > strlen(src) + strlen(dst))
	returns(dst)
	post (_ecv_isNullTerminated(dst))
	post (strlen(dst) == old(strlen(dst)) + strlen(src))
	post (forall i in 0..(old(strlen(dst)) - 1) :- dst[i] == old dst[i])
	post (forall i in 0..strlen(src) :- dst[i + old(strlen(dst))] == src[i])
;

spec char* array strncpy(out char* array dst, const char* array src, size_t len)
	writes(dst.all)
	pre(_ecv_isNullTerminated(src) || src.lim >= len)
	pre (disjoint(src.all, dst.all))
	pre(len <= dst.lim)
	returns(dst)
	post(forall i in 0..(len - 1) :- dst[i] == (_ecv_isNullTerminated(src) && i <= strlen(src) ? src[i] : old dst[i]))
	post(result == dst)
;

spec void* memcpy(void* dst, const void * src, size_t num)
	writes(dst.all)
	pre(dst.lim >= num; src.lim >= num)
	pre(disjoint(src.all, dst.all))
	returns(dst)
	post(_ecv_equalBytes(src, dst, num))
;

spec void* memmove(void* dst, const void * src, size_t num)
	writes(dst.all)
	pre(dst.lim >= num; src.lim >= num)
	returns(dst)
	post(_ecv_equalBytes(src, dst, num))
;

spec int memcmp(const void* dst, const void * src, size_t num)
	pre(dst.lim >= num; src.lim >= num)
	post((result == 0) == _ecv_equalBytes(src, dst, num))
;

spec void *memset(void* dst, int val, size_t num)
	writes(dst.all)
	pre(dst.lim >= num)
	returns(dst)
	post(_ecv_allBytesAre(dst, val, num))
;

#define isNullTerminated(_x) _ecv_isNullTerminated(_x)

#endif

/* End */
