// **************************************************************************
// * File:   AnyBase.cpp													*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Definition of non-inline member methods of class AnyBase		*
// **************************************************************************

#include "Ertsys.hpp"

#include "AnyBase.hpp"

// Get relative rank between 2 classes
_eRank :: _eEnum _eAnyBase :: _lClassRank(const _eAnyBase *other) const
{
	if (other == NULL)
	{
		return _eRank :: above;
	}

	_eFullTypeInfo *selfTypeInfo = const_cast<_eFullTypeInfo *>(_aGetFullTypeInfo());
	_eFullTypeInfo *otherTypeInfo = const_cast<_eFullTypeInfo *>(other->_aGetFullTypeInfo());

//	::debugPrint( _mString("selfTypeInfo:\n")._oPlusPlus(selfTypeInfo->typeInfo()toString())._oPlusPlus(_mString("\n\n"))._oPlusPlus(
//				  _mString("otherTypeInfo:\n")._oPlusPlus(otherTypeInfo->typeInfo()->toString())._oPlusPlus(_mString("\n\n")) ) );

	// Check whether they are the same class (ie. whether the type-info's point to the same object) ...
	if (selfTypeInfo == otherTypeInfo) return _eRank :: same;

	// Get the lengths of the superclass chains for each class
	int selfLen = selfTypeInfo->generation();
	int otherLen = otherTypeInfo->generation();

	// Truncate the longer path - changes either selfTypeInfo or otherTypeInfo ...
	int i = selfLen - otherLen;
	if (i > 0)
	{
		do
		{
			selfTypeInfo = const_cast<_eFullTypeInfo *>(selfTypeInfo->parent());
			--i;
		} while (i != 0);
	}
	else if (i < 0)
	{
		do
		{
			otherTypeInfo = const_cast<_eFullTypeInfo *>(otherTypeInfo->parent());
			++i;
		} while (i != 0);
	}

	// Check whether one class was a superclass of the other ...
	if (selfTypeInfo == otherTypeInfo)
	{
		return (selfLen > otherLen) ? _eRank :: above
				: (selfLen < otherLen) ? _eRank :: below
					: _eRank :: same;  			// a subclass ranks above its superclass
	}

	for (;;)
	{
		_eFullTypeInfo *q1 = const_cast<_eFullTypeInfo *>(selfTypeInfo->parent());
		_eFullTypeInfo *q2 = const_cast<_eFullTypeInfo *>(otherTypeInfo->parent());
		if (q1 == q2) return selfTypeInfo->name()._oRank(otherTypeInfo->name());
		selfTypeInfo = q1;
		otherTypeInfo = q2;
	}
}

// End
