// **************************************************************************
// * File:   StorableSupport_1.hpp											*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Declarations of global schemas used to store elements of		*
// *         collections.													*
// **************************************************************************

#if !defined(_h_Main_StorableSupport)
#define _h_Main_StorableSupport 1

//---------------------------------------------------------------------------------------------------
// Global versions of store(..) schema so we can store collections of templated types
//---------------------------------------------------------------------------------------------------

extern void _astoreGlobal(_eStoreStream* stream, const _eInt item);
extern void _astoreGlobal(_eStoreStream* stream, const _eBool item);
extern void _astoreGlobal(_eStoreStream* stream, const _eChar item);
extern void _astoreGlobal(_eStoreStream* stream, const _eReal item);
extern void _astoreGlobal(_eStoreStream* stream, const _eByte item);
extern void _astoreGlobal(_eStoreStream* stream, const _eUnion & item);

template<class X> inline void _astoreGlobal(_eStoreStream* stream, const _eHndl<X> & item)
{
	item._astore(stream);
}

template<class X> inline void _astoreGlobal(_eStoreStream* stream, const _eFrom<X> & item)
{
	item._astore(stream);
}

template<class X> inline void _astoreGlobal(_eStoreStream* stream, const _eRef<X> & item)
{
	item._astore(stream);
}

//-------------------------------------------------------------------------------------------------
// Global versions of fill(..) schema so we can load collections of templated types
//-------------------------------------------------------------------------------------------------

extern void _afillGlobal(_eFillStream* stream, _eInt & item);
extern void _afillGlobal(_eFillStream* stream, _eBool & item);
extern void _afillGlobal(_eFillStream* stream, _eChar & item);
extern void _afillGlobal(_eFillStream* stream, _eReal & item);
extern void _afillGlobal(_eFillStream* stream, _eByte & item);
extern void _afillGlobal(_eFillStream* stream, _eUnion & item);

template<class X> inline void _afillGlobal(_eFillStream* stream, _eHndl<X> & item)
{
	item._afill(stream);
}

template<class X> inline void _afillGlobal(_eFillStream* stream, _eFrom<X> & item)
{
	item._afill(stream);
}

template<class X> inline void _afillGlobal(_eFillStream* stream, _eRef<X> & item)
{
	item._afill(stream);
}

//--------------------------------------------------------------------------------------------------
// Function for deciding whether or not the type passed would be represented by the CV code passed.
// We use this to decide if a common CV code could be used to form a collection of the type, eg.
// 'bool' could, whereas 'from X' could not. We use this function to decide whether we can use the
// CV_REP stream syntax (so that we only store the type once instead of every time we store an
// element of the collection) ...
//--------------------------------------------------------------------------------------------------

inline _eComplexValue :: _eEnum _agetFixedCode(const _eBool & item)
{
	return _eComplexValue :: CV_BOOL;
}

inline _eComplexValue :: _eEnum _agetFixedCode(const _eChar & item)
{
	return _eComplexValue :: CV_CHAR;
}

inline _eComplexValue :: _eEnum _agetFixedCode(const _eReal & item)
{
	return _eComplexValue :: CV_DOUBLE;
}

inline _eComplexValue :: _eEnum _agetFixedCode(const _eByte & item)
{
	return _eComplexValue :: CV_BYTE;
}

inline _eComplexValue :: _eEnum _agetFixedCode(const _eInt & item)
{
	return _eComplexValue :: CV_RSVD;		// integers use variable number of bytes depending on the size
}

// This one caters for handles, froms and unions
inline _eComplexValue :: _eEnum _agetFixedCode(const _eBaseHandle & item)
{
	return _eComplexValue :: CV_RSVD;
}

template<class X> inline _eComplexValue :: _eEnum _agetFixedCode(const _eRef<X> & item)
{
	return _eComplexValue :: CV_RSVD;
}

//--------------------------------------------------------------------------------------------------------------
// Type-info constants for the builtin templates in the runtime system. For type-infos for builtin non-template
// types see file LoadableSupport_1.hpp (we use the '_mBuiltinTypeInform' macro in that case) ...
//--------------------------------------------------------------------------------------------------------------

extern _eHndl < _eInstblTypeInfo > SeqTypeInfo ();
extern _eHndl < _eInstblTypeInfo > SetTypeInfo ();
extern _eHndl < _eInstblTypeInfo > BagTypeInfo ();
extern _eHndl < _eInstblTypeInfo > MapTypeInfo ();
extern _eHndl < _eInstblTypeInfo > PairTypeInfo ();
extern _eHndl < _eInstblTypeInfo > TripleTypeInfo ();
extern _eHndl < _eInstblTypeInfo > Multiple2TypeInfo ();
extern _eHndl < _eInstblTypeInfo > Multiple3TypeInfo ();
extern _eHndl < _eInstblTypeInfo > Multiple4TypeInfo ();
extern _eHndl < _eInstblTypeInfo > RefTypeInfo ();

//------------------------------------------------------------------
// Macro defining store, fill and representedByCode methods for rank
//------------------------------------------------------------------

_mEnumStorableSupportHdr(_eRank)

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
