// **************************************************************************
// * File:   Order.hpp														*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Macros and templates for the Rank operator "~~"				*
// **************************************************************************

#if !defined(_h_order)
#define _h_order 1

//------------------------------------------------------
// Enumeration used for result of relative rank operator
//------------------------------------------------------

namespace _eRank
{	enum _eEnum
	{
		below, same, above
	};
    extern const _eNativeChar* _lnaming[3];
}
// members for rank are defined in 'MiscRts.hpp'

//------------------------------------------------------
// Define a swap schema for RelativeRank
//------------------------------------------------------
_mDefineSwap(_eRank :: _eEnum)

//---------------------------------------------------------------
// Order macro - this is used for any non-handle class with a
// member rank operator so we can use collections of such classes
// It must be declared 'inline' as the .hpp file it is generated
// in may be included by multiple .cpp files
//---------------------------------------------------------------

#define _mRank(own_Class_name)														\
	inline _eRank :: _eEnum _oRank(const own_Class_name x, const own_Class_name y)	\
	{	return x._oRank(y);															\
	}

//-----------------------------------------------------------------
// Macros used to define a full relative rank operator on any class
//-----------------------------------------------------------------

#define _mDefineRank(ownClassName)													\
	virtual _eRank :: _eEnum _oRank(const _eAnyBase* arg) const						\
	{	const ownClassName* ptr = dynamic_cast<const ownClassName*>(arg);			\
		if (ptr != NULL) 															\
		{	_eRank :: _eEnum _lTemp = _lRank(ptr);									\
			return (_lTemp == _eRank :: same) ? _lClassRank(arg) : _lTemp;			\
		}                                                                           \
		return _eAnyBase :: _oRank(arg);											\
	}

#define _mRedefineRank(ownClassName, overriddenClassName)							\
	virtual _eRank :: _eEnum _oRank(const _eAnyBase* arg) const						\
	{	const ownClassName* ptr = dynamic_cast<const ownClassName*>(arg);			\
		if (ptr != NULL) 															\
		{	_eRank :: _eEnum _lTemp = _lRank(ptr);									\
			return (_lTemp == _eRank :: same) ? _lClassRank(arg) : _lTemp;			\
		}                                                                           \
		return overriddenClassName :: _oRank(arg);									\
	}

//-------------------------------------------------------
// Forward declarations for handle, from, ref and union
// classes, so we can define relative rank for these
//-------------------------------------------------------

template <class X> class _eHndl;
template <class X> class _eFrom;
template <class X> class _eRef;
class _eUnion;

//--------------------------
// Relative rank for handles
//--------------------------

template <class X > _eRank :: _eEnum _oRank(const _eHndl<X >& x, const _eHndl<X >& y)
{
	return x.Ptr() == NULL
			? (y.Ptr() == NULL ? _eRank :: same : _eRank :: below)
			: y.Ptr() == NULL
			? _eRank :: above
			: x->_oRank(y.Ptr());
}

//------------------------
// Relative rank for froms
//------------------------

template<class X > _eRank :: _eEnum _oRank(const _eFrom<X >& x, const _eFrom<X >& y)
{
	return x.Ptr() == NULL
			? (y.Ptr() == NULL ? _eRank :: same : _eRank :: below)
			: y.Ptr() == NULL
			? _eRank :: above
			: x->_oRank(y.Ptr());
}

//---------------------------------------------------------------------------
// Relative rank for references ...
//---------------------------------------------------------------------------

template<class X > _eRank :: _eEnum _oRank(const _eRef<X > a, const _eRef<X > b)
{
	return a._oRank(b);
}

//---------------------------------------------------------------------------
// Relative rank for unions (complicated, so we define it in Order.cpp)
//---------------------------------------------------------------------------

extern _eRank :: _eEnum _oRank(const _eUnion& x, const _eUnion& y);

//-----------------------------------------------
// Definitions of relative rank for builtin types
//-----------------------------------------------

inline _eRank :: _eEnum _oRank(const _eInt x, const _eInt y)
{
	return (y < x) ? _eRank :: above
			: (x < y) ? _eRank :: below
				: _eRank :: same;
}

inline _eRank :: _eEnum _oRank(const _eReal x, const _eReal y)
{
	return (y < x) ? _eRank :: above
		: (x < y) ? _eRank :: below
			: _eRank :: same;
}

inline _eRank :: _eEnum _oRank(const _eChar x, const _eChar y)
{
	return (static_cast<_eUnsignedChar>(y) < static_cast<_eUnsignedChar>(x)) ? _eRank :: above
		: (static_cast<_eUnsignedChar>(x) < static_cast<_eUnsignedChar>(y)) ? _eRank :: below
			: _eRank :: same;
}

inline _eRank :: _eEnum _oRank(const _eByte x, const _eByte y)
{
	return (y < x) ? _eRank :: above
		: (x < y) ? _eRank :: below
			: _eRank :: same;
}

inline _eRank :: _eEnum _oRank(const _eBool x, const _eBool y)
{
	return (x & !y) ? _eRank :: above
		: (!x & y) ? _eRank :: below
			: _eRank :: same;
}

//--------------------------------------------------------------------------------------
// Rank for system addresses; used for the maps of address -> nat in class 'StoreStream'
//--------------------------------------------------------------------------------------

inline _eRank :: _eEnum _oRank (const _eAddress lhs, const _eAddress rhs)
{
    return ((lhs > rhs) ? _eRank :: above
		: (lhs < rhs) ? _eRank :: below
			: _eRank :: same);
}

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
