// **************************************************************************
// * File:   LinuxSystemCalls.hpp											*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Code to implement an interface between runtime and the			*
// *         target OS.														*
// **************************************************************************

#if !defined(_h_LinuxSystemcalls)
#define _h_LinuxSystemcalls

//-----------------------------------------------
// Functions grouped into namespace '_eosInterface'
//-----------------------------------------------

namespace _eosInterface
{
	//---------------------------------------------------------------------------------
	// Function: Initialize()
	// Purpose: Set up any static data that is needed.
	//---------------------------------------------------------------------------------
	void initialize();

	//---------------------------------------------------------------------------------
	// Function: normalizefilename(const char *path, const char *fname)
	// Purpose:  Given a filename and a default path ("path"), split it into a full
	//           path and a filename ("fname") without path. The default path must
	//           either be empty (in which case the current directory is assumed)
	//           or end in "/". The split parts are held in the FilePath object
	//           returned on success, else null is returned.
	//---------------------------------------------------------------------------------
	_eHndlUnionVoid<FilePath> normalizefilename(const _eNativeChar *path, const _eNativeChar *fname);

	//---------------------------------------------------------------------------------
	// Make chmod call to set file attributes
	//---------------------------------------------------------------------------------
	FileError :: _eEnum chmod(const _eNativeChar *fname, _eSet<FileAttribute :: _eEnum> atts);

	//-------------------------------------------------------------------
	// Function: caseSensitiveFileNames()
	// Purpose:  Obtain information from the OS as to whether or not the
	//           local filessystem is case sensitive.
	//-------------------------------------------------------------------
	bool caseSensitiveFileNames();

	//-------------------------------------------------------------------
	// Function: getPathSeparator()
	// Purpose:  Obtain information from the OS as to what the path
	//           separator character is on the local filessystem.
	//-------------------------------------------------------------------
	_eNativeChar getPathSeparator();

	//--------------------------------------------------------------------------------------------------------
	// Function: setCurrentThreadPriority(const _eNat priority)
	// Purpose:  Set the base priority of the current thread by setting the priority class of the current
	//           process, and the priority level of the current thread. 'Perfect' supports 20 priority levels.
	//           For more information, see MSDN entry "scheduling priorities".
	//--------------------------------------------------------------------------------------------------------
	bool setCurrentThreadPriority(const _eNat priority);

	//------------------------------------------------------------------------------
	// Function: getLocalTime()
	// Purpose:  Get the current local date and time, based on the current time-zone
	//			 settings.
	//------------------------------------------------------------------------------
	Time getLocalTime();

	//------------------------------------------------------------------------------
	// Function: getImageVersion(const char *moduleName)
	// Purpose:  Get the version information for the running executable image (this
	//           information will have been stored in the 'ProductVersion' field of
	//           the version resource of the project) as a sequence of integers (4
	//           integers for Win32)
	//------------------------------------------------------------------------------
	_eSeq < _eInt > getImageVersion(const _eNativeChar *moduleName);

	//---------------------------------------------------------------------------------------------
	// Function: getOsInfo()
	// Purpose:  Determine which operating system is currently running. Return details of OS-type
	//           (Linux etc) and major and minor OS-version numbers
	//---------------------------------------------------------------------------------------------
	_eHndl<OsInfo> getOsInfo();
}

#if defined(_dUnicode)
	// glibc doesn't define wide character file system interface routines, so we define them here
    #include <sys/stat.h>	// for struct stat
    #include <utime.h>		// for struct utimbuf

	FILE *_wfopen(const wchar_t *filename, const wchar_t *mode);
	int _wrename(const wchar_t *oldname, const wchar_t *newname);
	int _wunlink(const wchar_t *filename);
	int _waccess(const wchar_t *path, int mode);
	int _wstat(const wchar_t *path, struct ::stat *buffer);
	int _wutime(const wchar_t *filename, struct ::utimbuf *times);
	wchar_t *_wgetcwd(wchar_t *buffer, int maxlen);
	int _wchdir(const wchar_t *dirname);
	int _wchmod(const wchar_t *filename, int pmode);
	int _wmkdir(const wchar_t *dirname, __mode_t m);
#endif

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
