// **************************************************************************
// * File:   From.hpp														*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   The 'from' handle semantics									*
// **************************************************************************

#if !defined(_h_From)
#define _h_From 1

// We use '_eFromUnionVoid' when Object may be null for added clarity, but in fact the class is just _eFrom
#define _eFromUnionVoid _eFrom

template <class X>
class _eFrom : public _eBaseHandle
{
  public :

	// Default constructor, creates a 'null handle'
    _eFrom<X >() : _eBaseHandle()
	{
	}

	// Build a handle from an object pointer
	explicit _eFrom<X >(const X* xptr) : _eBaseHandle(xptr)
	{
	}

	// Note: we allow the system to generate the copy constructor and the copy assignment operator

	// Assign a handle from an object pointer
    _eFrom<X >& operator=(const X* h)
	{
		assign(h);
		return *this;
	}

	// Dereferencing operator, giving access to the object in a const way
    const X& operator*() const
    {
		return *(operator->());
    }

    // Used for getting at the object to get at members in a 'const' way.
    const X* operator->() const
    {
		checkUnionNotNull();
        return static_cast<const X*>(Object);
    }

    // Used for getting at the object to change it (result may be null)
    X& Change()
    {
        Unbind();
		return *static_cast<X*>(Object);
    }

	// Return a pointer to the object (possibly null)
	const X* Ptr() const
	{
		return static_cast<const X*> (Object);
	}

	// Return a changeable pointer to the object (possibly null)
	X* ChangePtr()
	{
		Unbind();
		return static_cast<X*> (Object);
	}

	//--------------------
	// Null check routines
	//--------------------

	_eFrom<X >& CheckNotNull()
	{
		checkUnionNotNull();
		return *this;
	}

	const _eFrom<X >& CheckNotNull() const
	{
		checkUnionNotNull();
		return *this;
	}

	_eFrom<X >& CheckIsNull()
	{
		checkUnionIsNull();
		return *this;
	}

	const _eFrom<X >& CheckIsNull() const
	{
		checkUnionIsNull();
		return *this;
	}

	// We define 'fill' here - 'store' is inherited from _eBaseHandle
	void _afill(_eFillStream* stream);

	// Type info function
	static _eHndl<_eInstblTypeInfo> _aMyTypeInfo();
};

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
