// **************************************************************************
// * File:   Emem.hpp														*
// * Target: C++ version of Perfect Developer runtime system				*
// * Author: (C) 2001 Escher Technologies Ltd.								*
// * Desc:   Memory management functionality.								*
// **************************************************************************

#if !defined(_h_emem_H)
#define _h_emem_H 1

namespace _eMem
{
	// Allocate memory
	void* alloc(_eSize s);
	// Release memory
	void free(void* p, _eSize s);
	// Garbage collect (return memory in free lists to system)
	void garbageCollect();
  #if _dThreadSafe
	bool initCritSectLocker();
  #endif
	// Reporting functions
	_eSize getManagedTotalAllocated();
	_eSize getUnmanagedTotalAllocated();
	_eSize getTotalInFreelists();
}

//---------------------------
// End of guarded header file
//---------------------------

#endif

// End.
